/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaom;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference blQ;
    private final Uri mUri;
    private final byte[] azn;
    private final byte[] bns;
    private final long bnt;
    private final AtomicLong bnu;
    private zzaod blS;
    private InputStream bnv;
    private boolean bnw;
    private volatile StorageMetadata bmv;
    private volatile Uri bnx;
    private volatile Exception aMX;
    private volatile Exception bny;
    private volatile int mResultCode;
    private volatile String bnz;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.bns = new byte[262144];
        this.bnu = new AtomicLong(0L);
        this.bnx = null;
        this.aMX = null;
        this.bny = null;
        this.mResultCode = 0;
        zzaa.zzy((Object)storageReference);
        zzaa.zzy((Object)byArray);
        this.azn = byArray;
        this.bnt = this.azn.length;
        this.blQ = storageReference;
        this.bmv = storageMetadata;
        this.mUri = null;
        this.bnv = new BufferedInputStream(new ByteArrayInputStream(this.azn), 262144);
        this.bnw = true;
        this.blS = new zzaod(this.blQ.getApp(), this.blQ.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.bns = new byte[262144];
            this.bnu = new AtomicLong(0L);
            this.bnx = null;
            this.aMX = null;
            this.bny = null;
            this.mResultCode = 0;
            zzaa.zzy((Object)storageReference);
            zzaa.zzy((Object)uri);
            this.azn = null;
            this.blQ = storageReference;
            this.bmv = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.blS = new zzaod(this.blQ.getApp(), this.blQ.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.blQ.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")));
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n > 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.aMX = fileNotFoundException;
            }
        }
        this.bnt = l;
        this.bnv = inputStream;
        this.bnw = true;
        this.bnx = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.bns = new byte[262144];
        this.bnu = new AtomicLong(0L);
        this.bnx = null;
        this.aMX = null;
        this.bny = null;
        this.mResultCode = 0;
        zzaa.zzy((Object)storageReference);
        zzaa.zzy((Object)inputStream);
        this.bnt = -1L;
        this.azn = null;
        this.blQ = storageReference;
        this.bmv = storageMetadata;
        this.bnv = new BufferedInputStream(inputStream, 262144);
        this.bnw = false;
        this.mUri = null;
        this.blS = new zzaod(this.blQ.getApp(), this.blQ.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.blQ;
    }

    long getTotalByteCount() {
        return this.bnt;
    }

    @Override
    protected void schedule() {
        zzd.aw().zzu(this.zzcnk());
    }

    @Override
    void run() {
        this.blS.reset();
        if (!this.zzf(4, false)) {
            Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
            return;
        }
        if (this.blQ.getParent() == null) {
            this.aMX = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.aMX != null) {
            return;
        }
        if (this.bnx == null) {
            this.aA();
        } else {
            this.zzde(false);
        }
        boolean bl = this.aB();
        while (bl) {
            this.aD();
            bl = this.aB();
            if (!bl) continue;
            this.zzf(4, false);
        }
        if (this.bnw) {
            try {
                this.bnv.close();
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.aMX = null;
        this.bny = null;
        this.mResultCode = 0;
        this.bnz = null;
    }

    private void aA() {
        Object object;
        String string = null;
        if (this.bmv != null) {
            string = this.bmv.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.blQ.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.blQ.an().zza(this.blQ.ao(), this.bmv != null ? this.bmv.am() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.aMX = throwable;
            return;
        }
        if (!this.zzb((zzaom)object)) {
            return;
        }
        String string2 = ((zzaom)object).zzul("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.bnx = Uri.parse((String)string2);
        }
    }

    private boolean aB() {
        boolean bl;
        if (this.aq() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.aMX = new InterruptedException();
            this.zzf(64, false);
            return false;
        }
        if (this.aq() == 32) {
            this.zzf(256, false);
            return false;
        }
        if (this.aq() == 8) {
            this.zzf(16, false);
            return false;
        }
        if (!this.aC()) {
            return false;
        }
        if (this.bnx == null) {
            if (this.aMX == null) {
                this.aMX = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzf(64, false);
            return false;
        }
        if (this.aMX != null) {
            this.zzf(64, false);
            return false;
        }
        boolean bl2 = bl = this.bny != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzde(true)) {
            if (this.aC()) {
                this.zzf(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean aC() {
        if ("final".equals(this.bnz)) {
            if (this.aMX == null) {
                this.aMX = new IOException("The server has terminated the upload session");
            }
            this.zzf(64, false);
            return false;
        }
        return true;
    }

    private boolean zzde(boolean bl) {
        zzaom zzaom2;
        try {
            zzaom2 = this.blQ.an().zzb(this.blQ.ao(), this.bnx.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.aMX = remoteException;
            return false;
        }
        if ("final".equals(this.bnz)) {
            return false;
        }
        if (bl ? !this.zzb(zzaom2) : !this.zza(zzaom2)) {
            return false;
        }
        if ("final".equals(zzaom2.zzul("X-Goog-Upload-Status"))) {
            this.aMX = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzaom2.zzul("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.bnu.get();
        if (l2 > l) {
            this.aMX = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if (this.bnv.skip(l - l2) != l - l2) {
                    this.aMX = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.bnu.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.aMX = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.aMX = iOException;
                return false;
            }
        }
        return true;
    }

    private void aD() {
        zzaom zzaom2;
        int n;
        this.bnv.mark(this.bns.length + 1);
        try {
            n = this.bnv.read(this.bns);
        }
        catch (IOException iOException) {
            Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
            this.aMX = iOException;
            return;
        }
        try {
            zzaom2 = this.blQ.an().zza(this.blQ.ao(), this.bnx.toString(), this.bns, this.bnu.get(), n, (long)n != 262144L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            this.aMX = remoteException;
            return;
        }
        if (!this.zza(zzaom2)) {
            try {
                this.bnv.reset();
            }
            catch (IOException iOException) {
                Log.w((String)"UploadTask", (String)"Unable to reset the stream for error recovery.", (Throwable)iOException);
                this.aMX = iOException;
            }
            return;
        }
        if (n != -1) {
            this.bnu.getAndAdd(n);
        }
        if ((long)n != 262144L) {
            try {
                this.bmv = new StorageMetadata.Builder(zzaom2.aQ(), this.blQ).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzaom2.aK());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                this.aMX = throwable;
                return;
            }
            this.zzf(4, false);
            this.zzf(128, false);
        }
    }

    private boolean zzagg(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zza(zzaom zzaom2) {
        zzaom2.zza(zzaoi.zzi(this.blQ.getApp()), this.blQ.getApp().getApplicationContext());
        return this.zzc(zzaom2);
    }

    private boolean zzb(zzaom zzaom2) {
        this.blS.zzd(zzaom2);
        return this.zzc(zzaom2);
    }

    private boolean zzc(zzaom zzaom2) {
        int n = zzaom2.getResultCode();
        this.mResultCode = this.blS.zzagk(n) ? -2 : n;
        this.bny = zzaom2.getException();
        this.bnz = zzaom2.zzul("X-Goog-Upload-Status");
        return this.zzagg(this.mResultCode) && this.bny == null;
    }

    @Override
    protected void onCanceled() {
        this.blS.cancel();
        zzaom zzaom2 = null;
        if (this.bnx != null) {
            try {
                zzaom2 = this.blQ.an().zza(this.blQ.ao(), this.bnx.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzaom2 != null) {
            final zzaom zzaom3 = zzaom2;
            zzd.aw().zzt(new Runnable(){

                @Override
                public void run() {
                    zzaom3.zza(zzaoi.zzi(UploadTask.this.blQ.getApp()), UploadTask.this.blQ.getApp().getApplicationContext());
                }
            });
        }
        this.aMX = StorageException.fromErrorStatus(Status.yd);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot aE() {
        Exception exception = this.aMX != null ? this.aMX : this.bny;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.bnu.get(), this.bnx, this.bmv);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError ak() {
        return this.aE();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bnC;
        private final Uri bnx;
        private final StorageMetadata bmv;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.bnC = l;
            this.bnx = uri;
            this.bmv = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.bnC;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.bnx;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.bmv;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

