/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.extensions.Comments;
import com.google.gdata.data.extensions.EventEntry;
import com.google.gdata.data.extensions.OriginalEvent;
import com.google.gdata.data.extensions.Recurrence;
import com.google.gdata.data.extensions.RecurrenceException;
import com.google.gdata.data.extensions.Reminder;
import com.google.gdata.data.extensions.When;
import com.google.gdata.data.extensions.Where;
import com.google.gdata.util.Namespaces;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEventEntry<E extends BaseEventEntry<E>>
extends BaseEntry<E> {
    public BaseEventEntry() {
        this.getCategories().add(EventEntry.EVENT_CATEGORY);
    }

    public BaseEventEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
        this.getCategories().add(EventEntry.EVENT_CATEGORY);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        Class<?> eventEntryClass = ((Object)((Object)this)).getClass();
        extProfile.declare(eventEntryClass, RecurrenceException.getDefaultDescription());
        extProfile.declare(eventEntryClass, Reminder.getDefaultDescription());
        extProfile.declare(eventEntryClass, Recurrence.getDefaultDescription());
        extProfile.declare(eventEntryClass, Where.getDefaultDescription());
        extProfile.declare(eventEntryClass, EventStatus.getDefaultDescription());
        extProfile.declare(eventEntryClass, Visibility.getDefaultDescription());
        extProfile.declare(eventEntryClass, Transparency.getDefaultDescription());
        extProfile.declare(eventEntryClass, When.getDefaultDescription());
        extProfile.declare(eventEntryClass, OriginalEvent.getDefaultDescription());
        extProfile.declare(eventEntryClass, Comments.getDefaultDescription());
        extProfile.declare(When.class, Reminder.getDefaultDescription());
    }

    public List<When> getTimes() {
        return this.getRepeatingExtension(When.class);
    }

    public void addTime(When time) {
        this.getTimes().add(time);
    }

    public List<Where> getLocations() {
        return this.getRepeatingExtension(Where.class);
    }

    public void addLocation(Where location) {
        this.getLocations().add(location);
    }

    public EventStatus getStatus() {
        return (EventStatus)this.getExtension(EventStatus.class);
    }

    public void setStatus(EventStatus status) {
        this.setExtension((Extension)status);
    }

    public Visibility getVisibility() {
        return (Visibility)this.getExtension(Visibility.class);
    }

    public void setVisibility(Visibility v) {
        this.setExtension((Extension)v);
    }

    public Transparency getTransparency() {
        return (Transparency)this.getExtension(Transparency.class);
    }

    public void setTransparency(Transparency transparency) {
        this.setExtension((Extension)transparency);
    }

    public Recurrence getRecurrence() {
        return (Recurrence)this.getExtension(Recurrence.class);
    }

    public void setRecurrence(Recurrence v) {
        this.setExtension(v);
    }

    public List<RecurrenceException> getRecurrenceException() {
        return this.getRepeatingExtension(RecurrenceException.class);
    }

    public void addRecurrenceException(RecurrenceException exception) {
        this.getRecurrenceException().add(exception);
    }

    public OriginalEvent getOriginalEvent() {
        return (OriginalEvent)this.getExtension(OriginalEvent.class);
    }

    public void setOriginalEvent(OriginalEvent v) {
        this.setExtension(v);
    }

    public List<Reminder> getReminder() {
        if (this.getRecurrence() != null) {
            return this.getRepeatingExtension(Reminder.class);
        }
        List<When> whenList = this.getTimes();
        if (whenList.size() >= 1) {
            return whenList.get(0).getRepeatingExtension(Reminder.class);
        }
        return null;
    }

    public static class Transparency
    extends ValueConstruct {
        public static final String OPAQUE_VALUE = "http://schemas.google.com/g/2005#event.opaque";
        public static final String TRANSPARENT_VALUE = "http://schemas.google.com/g/2005#event.transparent";
        public static final Transparency OPAQUE = new Transparency("http://schemas.google.com/g/2005#event.opaque");
        public static final Transparency TRANSPARENT = new Transparency("http://schemas.google.com/g/2005#event.transparent");

        public Transparency() {
            super(Namespaces.gNs, "transparency", "value");
        }

        public Transparency(String value) {
            super(Namespaces.gNs, "transparency", "value", value);
        }

        public static ExtensionDescription getDefaultDescription() {
            return new ExtensionDescription(Transparency.class, Namespaces.gNs, "transparency");
        }
    }

    public static class Visibility
    extends ValueConstruct {
        public static final String DEFAULT_VALUE = "http://schemas.google.com/g/2005#event.default";
        public static final String PUBLIC_VALUE = "http://schemas.google.com/g/2005#event.public";
        public static final String CONFIDENTIAL_VALUE = "http://schemas.google.com/g/2005#event.confidential";
        public static final String PRIVATE_VALUE = "http://schemas.google.com/g/2005#event.private";
        public static final Visibility DEFAULT = new Visibility("http://schemas.google.com/g/2005#event.default");
        public static final Visibility PUBLIC = new Visibility("http://schemas.google.com/g/2005#event.public");
        public static final Visibility CONFIDENTIAL = new Visibility("http://schemas.google.com/g/2005#event.confidential");
        public static final Visibility PRIVATE = new Visibility("http://schemas.google.com/g/2005#event.private");

        public Visibility() {
            super(Namespaces.gNs, "visibility", "value");
        }

        public Visibility(String value) {
            super(Namespaces.gNs, "visibility", "value", value);
        }

        public static ExtensionDescription getDefaultDescription() {
            return new ExtensionDescription(Visibility.class, Namespaces.gNs, "visibility");
        }
    }

    public static class EventStatus
    extends ValueConstruct {
        public static final String CONFIRMED_VALUE = "http://schemas.google.com/g/2005#event.confirmed";
        public static final String TENTATIVE_VALUE = "http://schemas.google.com/g/2005#event.tentative";
        public static final String CANCELED_VALUE = "http://schemas.google.com/g/2005#event.canceled";
        public static final EventStatus CONFIRMED = new EventStatus("http://schemas.google.com/g/2005#event.confirmed");
        public static final EventStatus TENTATIVE = new EventStatus("http://schemas.google.com/g/2005#event.tentative");
        public static final EventStatus CANCELED = new EventStatus("http://schemas.google.com/g/2005#event.canceled");

        public EventStatus() {
            super(Namespaces.gNs, "eventStatus", "value");
        }

        public EventStatus(String value) {
            super(Namespaces.gNs, "eventStatus", "value", value);
        }

        public static ExtensionDescription getDefaultDescription() {
            ExtensionDescription desc = new ExtensionDescription();
            desc.setExtensionClass(EventStatus.class);
            desc.setNamespace(Namespaces.gNs);
            desc.setLocalName("eventStatus");
            desc.setRepeatable(false);
            return desc;
        }
    }
}

