/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.AutoValue_LiveClientSetup;
import com.google.genai.types.Content;
import com.google.genai.types.ContextWindowCompressionConfig;
import com.google.genai.types.GenerationConfig;
import com.google.genai.types.ProactivityConfig;
import com.google.genai.types.RealtimeInputConfig;
import com.google.genai.types.SessionResumptionConfig;
import com.google.genai.types.Tool;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveClientSetup
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="generationConfig")
    public abstract Optional<GenerationConfig> generationConfig();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="realtimeInputConfig")
    public abstract Optional<RealtimeInputConfig> realtimeInputConfig();

    @JsonProperty(value="sessionResumption")
    public abstract Optional<SessionResumptionConfig> sessionResumption();

    @JsonProperty(value="contextWindowCompression")
    public abstract Optional<ContextWindowCompressionConfig> contextWindowCompression();

    @JsonProperty(value="inputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> inputAudioTranscription();

    @JsonProperty(value="outputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> outputAudioTranscription();

    @JsonProperty(value="proactivity")
    public abstract Optional<ProactivityConfig> proactivity();

    public static Builder builder() {
        return new AutoValue_LiveClientSetup.Builder();
    }

    public abstract Builder toBuilder();

    public static LiveClientSetup fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveClientSetup.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveClientSetup.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @JsonProperty(value="generationConfig")
        public abstract Builder generationConfig(GenerationConfig var1);

        public Builder generationConfig(GenerationConfig.Builder generationConfigBuilder) {
            return this.generationConfig(generationConfigBuilder.build());
        }

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        public Builder systemInstruction(Content.Builder systemInstructionBuilder) {
            return this.systemInstruction(systemInstructionBuilder.build());
        }

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        public Builder tools(Tool.Builder ... toolsBuilders) {
            return this.tools((List)Arrays.asList(toolsBuilders).stream().map(Tool.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="realtimeInputConfig")
        public abstract Builder realtimeInputConfig(RealtimeInputConfig var1);

        public Builder realtimeInputConfig(RealtimeInputConfig.Builder realtimeInputConfigBuilder) {
            return this.realtimeInputConfig(realtimeInputConfigBuilder.build());
        }

        @JsonProperty(value="sessionResumption")
        public abstract Builder sessionResumption(SessionResumptionConfig var1);

        public Builder sessionResumption(SessionResumptionConfig.Builder sessionResumptionBuilder) {
            return this.sessionResumption(sessionResumptionBuilder.build());
        }

        @JsonProperty(value="contextWindowCompression")
        public abstract Builder contextWindowCompression(ContextWindowCompressionConfig var1);

        public Builder contextWindowCompression(ContextWindowCompressionConfig.Builder contextWindowCompressionBuilder) {
            return this.contextWindowCompression(contextWindowCompressionBuilder.build());
        }

        @JsonProperty(value="inputAudioTranscription")
        public abstract Builder inputAudioTranscription(AudioTranscriptionConfig var1);

        public Builder inputAudioTranscription(AudioTranscriptionConfig.Builder inputAudioTranscriptionBuilder) {
            return this.inputAudioTranscription(inputAudioTranscriptionBuilder.build());
        }

        @JsonProperty(value="outputAudioTranscription")
        public abstract Builder outputAudioTranscription(AudioTranscriptionConfig var1);

        public Builder outputAudioTranscription(AudioTranscriptionConfig.Builder outputAudioTranscriptionBuilder) {
            return this.outputAudioTranscription(outputAudioTranscriptionBuilder.build());
        }

        @JsonProperty(value="proactivity")
        public abstract Builder proactivity(ProactivityConfig var1);

        public Builder proactivity(ProactivityConfig.Builder proactivityBuilder) {
            return this.proactivity(proactivityBuilder.build());
        }

        public abstract LiveClientSetup build();
    }
}

