/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.TrieNode;

class Trie {
    private TrieNode root = new TrieNode();

    public void insert(String word) {
        TrieNode node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            int index = ch - 97;
            if (node.childreNode.get(Character.valueOf(ch)) == null) {
                node.childreNode.put(Character.valueOf(ch), new TrieNode());
            }
            node = node.childreNode.get(Character.valueOf(ch));
            if (i != word.length() - 1) continue;
            ++node.freq;
        }
    }

    public boolean search(String word) {
        TrieNode node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            node = node.childreNode.get(Character.valueOf(ch));
            if (node == null) {
                return false;
            }
            if (i != word.length() - 1 || node.freq <= 0) continue;
            return true;
        }
        return false;
    }

    public int prefixLen(String word) {
        char ch;
        TrieNode node = this.root;
        int result = 0;
        for (int i = 0; i < word.length() && (node = node.childreNode.get(Character.valueOf(ch = word.charAt(i)))) != null; ++i) {
            if (node.freq <= 0) continue;
            result = i + 1;
        }
        return result;
    }

    public boolean startsWith(String prefix) {
        TrieNode node = this.root;
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            int index = ch - 97;
            node = node.childreNode.get(Character.valueOf(ch));
            if (node == null) {
                return false;
            }
            if (i != prefix.length() - 1) continue;
            return true;
        }
        return false;
    }
}

