/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_File;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FileSource;
import com.google.genai.types.FileState;
import com.google.genai.types.FileStatus;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class File
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="mimeType")
    public abstract Optional<String> mimeType();

    @JsonProperty(value="sizeBytes")
    public abstract Optional<Long> sizeBytes();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="expirationTime")
    public abstract Optional<Instant> expirationTime();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @JsonProperty(value="sha256Hash")
    public abstract Optional<String> sha256Hash();

    @JsonProperty(value="uri")
    public abstract Optional<String> uri();

    @JsonProperty(value="downloadUri")
    public abstract Optional<String> downloadUri();

    @JsonProperty(value="state")
    public abstract Optional<FileState> state();

    @JsonProperty(value="source")
    public abstract Optional<FileSource> source();

    @JsonProperty(value="videoMetadata")
    public abstract Optional<Map<String, Object>> videoMetadata();

    @JsonProperty(value="error")
    public abstract Optional<FileStatus> error();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_File.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static File fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, File.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_File.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @JsonProperty(value="mimeType")
        public abstract Builder mimeType(String var1);

        @JsonProperty(value="sizeBytes")
        public abstract Builder sizeBytes(Long var1);

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @JsonProperty(value="expirationTime")
        public abstract Builder expirationTime(Instant var1);

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @JsonProperty(value="sha256Hash")
        public abstract Builder sha256Hash(String var1);

        @JsonProperty(value="uri")
        public abstract Builder uri(String var1);

        @JsonProperty(value="downloadUri")
        public abstract Builder downloadUri(String var1);

        @JsonProperty(value="state")
        public abstract Builder state(FileState var1);

        @CanIgnoreReturnValue
        public Builder state(FileState.Known knownType) {
            return this.state(new FileState(knownType));
        }

        @CanIgnoreReturnValue
        public Builder state(String state) {
            return this.state(new FileState(state));
        }

        @JsonProperty(value="source")
        public abstract Builder source(FileSource var1);

        @CanIgnoreReturnValue
        public Builder source(FileSource.Known knownType) {
            return this.source(new FileSource(knownType));
        }

        @CanIgnoreReturnValue
        public Builder source(String source) {
            return this.source(new FileSource(source));
        }

        @JsonProperty(value="videoMetadata")
        public abstract Builder videoMetadata(Map<String, Object> var1);

        @JsonProperty(value="error")
        public abstract Builder error(FileStatus var1);

        public Builder error(FileStatus.Builder errorBuilder) {
            return this.error(errorBuilder.build());
        }

        public abstract File build();
    }
}

