/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.ConflictingRequirementsException;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.TesterAnnotation;
import com.google.common.collect.testing.features.TesterRequirements;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NullMarked;

@GwtIncompatible
public final class FeatureUtil {
    private static final Map<AnnotatedElement, List<Annotation>> annotationCache = new HashMap<AnnotatedElement, List<Annotation>>();
    private static final Map<Class<?>, TesterRequirements> classTesterRequirementsCache = new HashMap();
    private static final Map<Method, TesterRequirements> methodTesterRequirementsCache = new HashMap<Method, TesterRequirements>();

    @CanIgnoreReturnValue
    public static Set<Feature<?>> addImpliedFeatures(Set<Feature<?>> features) {
        ArrayDeque queue = new ArrayDeque(features);
        while (!queue.isEmpty()) {
            Feature feature = (Feature)queue.remove();
            for (Feature implied : feature.getImpliedFeatures()) {
                if (!features.add(implied)) continue;
                queue.add(implied);
            }
        }
        return features;
    }

    public static Set<Feature<?>> impliedFeatures(Set<Feature<?>> features) {
        LinkedHashSet impliedSet = new LinkedHashSet();
        ArrayDeque queue = new ArrayDeque(features);
        while (!queue.isEmpty()) {
            Feature feature = (Feature)queue.remove();
            for (Feature implied : feature.getImpliedFeatures()) {
                if (features.contains(implied) || !impliedSet.add(implied)) continue;
                queue.add(implied);
            }
        }
        return impliedSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TesterRequirements getTesterRequirements(Class<?> testerClass) throws ConflictingRequirementsException {
        Map<Class<?>, TesterRequirements> map = classTesterRequirementsCache;
        synchronized (map) {
            TesterRequirements requirements = classTesterRequirementsCache.get(testerClass);
            if (requirements == null) {
                requirements = FeatureUtil.buildTesterRequirements(testerClass);
                classTesterRequirementsCache.put(testerClass, requirements);
            }
            return requirements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TesterRequirements getTesterRequirements(Method testerMethod) throws ConflictingRequirementsException {
        Map<Method, TesterRequirements> map = methodTesterRequirementsCache;
        synchronized (map) {
            TesterRequirements requirements = methodTesterRequirementsCache.get(testerMethod);
            if (requirements == null) {
                requirements = FeatureUtil.buildTesterRequirements(testerMethod);
                methodTesterRequirementsCache.put(testerMethod, requirements);
            }
            return requirements;
        }
    }

    static TesterRequirements buildTesterRequirements(Class<?> testerClass) throws ConflictingRequirementsException {
        TesterRequirements declaredRequirements = FeatureUtil.buildDeclaredTesterRequirements(testerClass);
        Class<?> baseClass = testerClass.getSuperclass();
        if (baseClass == null) {
            return declaredRequirements;
        }
        TesterRequirements clonedBaseRequirements = new TesterRequirements(FeatureUtil.getTesterRequirements(baseClass));
        return FeatureUtil.incorporateRequirements(clonedBaseRequirements, declaredRequirements, testerClass);
    }

    static TesterRequirements buildTesterRequirements(Method testerMethod) throws ConflictingRequirementsException {
        TesterRequirements clonedClassRequirements = new TesterRequirements(FeatureUtil.getTesterRequirements(testerMethod.getDeclaringClass()));
        TesterRequirements declaredRequirements = FeatureUtil.buildDeclaredTesterRequirements(testerMethod);
        return FeatureUtil.incorporateRequirements(clonedClassRequirements, declaredRequirements, testerMethod);
    }

    private static TesterRequirements buildTesterRequirements(Annotation testerAnnotation) throws ConflictingRequirementsException {
        Feature[] absentFeatures;
        Feature[] presentFeatures;
        Class<? extends Annotation> annotationClass = testerAnnotation.annotationType();
        try {
            presentFeatures = (Feature[])annotationClass.getMethod("value", new Class[0]).invoke((Object)testerAnnotation, new Object[0]);
            absentFeatures = (Feature[])annotationClass.getMethod("absent", new Class[0]).invoke((Object)testerAnnotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error extracting features from tester annotation.", e);
        }
        Set<Feature<?>> allPresentFeatures = FeatureUtil.addImpliedFeatures(Helpers.copyToSet(presentFeatures));
        Set<Feature<?>> allAbsentFeatures = Helpers.copyToSet(absentFeatures);
        if (!Collections.disjoint(allPresentFeatures, allAbsentFeatures)) {
            throw new ConflictingRequirementsException("Annotation explicitly or implicitly requires one or more features to be both present and absent.", FeatureUtil.intersection(allPresentFeatures, allAbsentFeatures), testerAnnotation);
        }
        return new TesterRequirements(allPresentFeatures, allAbsentFeatures);
    }

    public static TesterRequirements buildDeclaredTesterRequirements(AnnotatedElement classOrMethod) throws ConflictingRequirementsException {
        TesterRequirements requirements = new TesterRequirements();
        Iterable<Annotation> testerAnnotations = FeatureUtil.getTesterAnnotations(classOrMethod);
        for (Annotation testerAnnotation : testerAnnotations) {
            TesterRequirements moreRequirements = FeatureUtil.buildTesterRequirements(testerAnnotation);
            FeatureUtil.incorporateRequirements(requirements, moreRequirements, testerAnnotation);
        }
        return requirements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Annotation> getTesterAnnotations(AnnotatedElement classOrMethod) {
        Map<AnnotatedElement, List<Annotation>> map = annotationCache;
        synchronized (map) {
            List<Annotation> annotations = annotationCache.get(classOrMethod);
            if (annotations == null) {
                annotations = new ArrayList<Annotation>();
                for (Annotation a : classOrMethod.getDeclaredAnnotations()) {
                    if (a instanceof NullMarked || !a.annotationType().isAnnotationPresent(TesterAnnotation.class)) continue;
                    annotations.add(a);
                }
                annotations = Collections.unmodifiableList(annotations);
                annotationCache.put(classOrMethod, annotations);
            }
            return annotations;
        }
    }

    @CanIgnoreReturnValue
    private static TesterRequirements incorporateRequirements(TesterRequirements requirements, TesterRequirements moreRequirements, Object source) throws ConflictingRequirementsException {
        Set<Feature<?>> presentFeatures = requirements.getPresentFeatures();
        Set<Feature<?>> absentFeatures = requirements.getAbsentFeatures();
        Set<Feature<?>> morePresentFeatures = moreRequirements.getPresentFeatures();
        Set<Feature<?>> moreAbsentFeatures = moreRequirements.getAbsentFeatures();
        FeatureUtil.checkConflict("absent", absentFeatures, "present", morePresentFeatures, source);
        FeatureUtil.checkConflict("present", presentFeatures, "absent", moreAbsentFeatures, source);
        presentFeatures.addAll(morePresentFeatures);
        absentFeatures.addAll(moreAbsentFeatures);
        return requirements;
    }

    private static void checkConflict(String earlierRequirement, Set<Feature<?>> earlierFeatures, String newRequirement, Set<Feature<?>> newFeatures, Object source) throws ConflictingRequirementsException {
        if (!Collections.disjoint(newFeatures, earlierFeatures)) {
            throw new ConflictingRequirementsException(String.format(Locale.ROOT, "Annotation requires to be %s features that earlier annotations required to be %s.", newRequirement, earlierRequirement), FeatureUtil.intersection(newFeatures, earlierFeatures), source);
        }
    }

    @Deprecated
    public static <T> Set<T> intersection(Set<? extends T> set1, Set<? extends T> set2) {
        Set<T> result = Helpers.copyToSet(set1);
        result.retainAll(set2);
        return result;
    }

    private FeatureUtil() {
    }
}

