/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
final class ClusterException
extends RuntimeException {
    final Collection<? extends Throwable> exceptions;

    private ClusterException(Collection<? extends Throwable> exceptions) {
        super(exceptions.size() + " exceptions were thrown. The first exception is listed as a cause.", exceptions.iterator().next());
        ArrayList<? extends Throwable> temp = new ArrayList<Throwable>(exceptions);
        this.exceptions = Collections.unmodifiableCollection(temp);
    }

    static RuntimeException create(Throwable ... exceptions) {
        ArrayList<Throwable> temp = new ArrayList<Throwable>(Arrays.asList(exceptions));
        return ClusterException.create(temp);
    }

    static RuntimeException create(Collection<? extends Throwable> exceptions) {
        if (exceptions.size() == 0) {
            throw new IllegalArgumentException("Can't create an ExceptionCollection with no exceptions");
        }
        if (exceptions.size() == 1) {
            Throwable temp = exceptions.iterator().next();
            if (temp instanceof RuntimeException) {
                return (RuntimeException)temp;
            }
            return new RuntimeException(temp);
        }
        return new ClusterException(exceptions);
    }
}

