/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.Widget;

public class Hyperlink
extends Widget
implements HasHTML,
SourcesClickEvents {
    private Element anchorElem;
    private ClickListenerCollection clickListeners;
    private String targetHistoryToken;

    public Hyperlink() {
        this.setElement(DOM.createDiv());
        this.anchorElem = DOM.createAnchor();
        DOM.appendChild(this.getElement(), this.anchorElem);
        this.sinkEvents(1);
        this.setStyleName("gwt-Hyperlink");
    }

    public Hyperlink(String text, boolean asHTML, String targetHistoryToken) {
        this();
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setTargetHistoryToken(targetHistoryToken);
    }

    public Hyperlink(String text, String targetHistoryToken) {
        this();
        this.setText(text);
        this.setTargetHistoryToken(targetHistoryToken);
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
        }
        this.clickListeners.add(listener);
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.anchorElem);
    }

    public String getTargetHistoryToken() {
        return this.targetHistoryToken;
    }

    public String getText() {
        return DOM.getInnerText(this.anchorElem);
    }

    public void onBrowserEvent(Event event) {
        if (DOM.eventGetType(event) == 1) {
            if (this.clickListeners != null) {
                this.clickListeners.fireClick(this);
            }
            History.newItem(this.targetHistoryToken);
            DOM.eventPreventDefault(event);
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.anchorElem, html);
    }

    public void setTargetHistoryToken(String targetHistoryToken) {
        this.targetHistoryToken = targetHistoryToken;
        DOM.setAttribute(this.anchorElem, "href", "#" + targetHistoryToken);
    }

    public void setText(String text) {
        DOM.setInnerHTML(this.anchorElem, text);
    }
}

