/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerImpl
extends Scheduler {
    static final Scheduler.RepeatingCommand FLUSHER = new Scheduler.RepeatingCommand(){

        public boolean execute() {
            flushRunning = true;
            SchedulerImpl.flushPostEventPumpCommands();
            flushRunning = false;
            return shouldBeRunning = SchedulerImpl.isWorkQueued();
        }
    };
    static final Scheduler.RepeatingCommand RESCUE = new Scheduler.RepeatingCommand(){

        public boolean execute() {
            if (flushRunning) {
                SchedulerImpl.scheduleFixedDelayImpl(FLUSHER, 1);
            }
            return shouldBeRunning;
        }
    };
    static final Task TOMBSTONE = (Task)JavaScriptObject.createObject().cast();
    static final JsArray<Task> DEFERRED_COMMANDS = (JsArray)JavaScriptObject.createArray().cast();
    static final JsArray<Task> INCREMENTAL_COMMANDS = (JsArray)JavaScriptObject.createArray().cast();
    static final JsArray<Task> FINALLY_COMMANDS = (JsArray)JavaScriptObject.createArray().cast();
    private static boolean shouldBeRunning = false;
    private static boolean flushRunning = false;
    private static final int FLUSHER_DELAY = 1;
    private static final int RESCUE_DELAY = 50;
    private static final double TIME_SLICE = 100.0;

    public static void scheduleDeferredImpl(Scheduler.ScheduledCommand cmd) {
        DEFERRED_COMMANDS.push(Task.create(cmd));
        SchedulerImpl.maybeSchedulePostEventPumpCommands();
    }

    public static void scheduleFinallyImpl(Scheduler.ScheduledCommand cmd) {
        FINALLY_COMMANDS.push(Task.create(cmd));
    }

    public static native void scheduleFixedDelayImpl(Scheduler.RepeatingCommand var0, int var1);

    public static native void scheduleFixedPeriodImpl(Scheduler.RepeatingCommand var0, int var1);

    public static void scheduleIncrementalImpl(Scheduler.RepeatingCommand cmd) {
        DEFERRED_COMMANDS.push(Task.create(cmd));
        SchedulerImpl.maybeSchedulePostEventPumpCommands();
    }

    static void flushFinallyCommands() {
        SchedulerImpl.runScheduledTasks(FINALLY_COMMANDS, FINALLY_COMMANDS);
    }

    static void flushPostEventPumpCommands() {
        SchedulerImpl.runScheduledTasks(DEFERRED_COMMANDS, INCREMENTAL_COMMANDS);
        SchedulerImpl.runRepeatingTasks(INCREMENTAL_COMMANDS);
    }

    static boolean isWorkQueued() {
        return DEFERRED_COMMANDS.length() > 0 || INCREMENTAL_COMMANDS.length() > 0;
    }

    private static boolean execute(Scheduler.RepeatingCommand cmd) {
        return cmd.execute();
    }

    private static void maybeSchedulePostEventPumpCommands() {
        if (!shouldBeRunning) {
            shouldBeRunning = true;
            SchedulerImpl.scheduleFixedDelayImpl(FLUSHER, 1);
            SchedulerImpl.scheduleFixedDelayImpl(RESCUE, 50);
        }
    }

    private static void runRepeatingTasks(JsArray<Task> tasks) {
        boolean canceledSomeTasks = false;
        int length = tasks.length();
        double start = Duration.currentTimeMillis();
        while (Duration.currentTimeMillis() - start < 100.0) {
            for (int i = 0; i < length; ++i) {
                Task t = tasks.get(i);
                if (t == TOMBSTONE) continue;
                assert (t.isRepeating()) : "Found a non-repeating Task";
                if (t.executeRepeating()) continue;
                tasks.set(i, TOMBSTONE);
                canceledSomeTasks = true;
            }
        }
        if (canceledSomeTasks) {
            int last = 0;
            for (int i = 0; i < length; ++i) {
                if (tasks.get(i) == TOMBSTONE) continue;
                tasks.set(last++, tasks.get(i));
            }
            tasks.setLength(last + 1);
        }
    }

    private static void runScheduledTasks(JsArray<Task> tasks, JsArray<Task> rescheduled) {
        while (tasks.length() > 0) {
            Task t = tasks.shift();
            try {
                if (t.isRepeating()) {
                    if (!t.executeRepeating()) continue;
                    rescheduled.push(t);
                    continue;
                }
                t.executeScheduled();
            }
            catch (RuntimeException e) {
                if (GWT.getUncaughtExceptionHandler() == null) continue;
                GWT.getUncaughtExceptionHandler().onUncaughtException(e);
            }
        }
    }

    @Override
    public void scheduleDeferred(Scheduler.ScheduledCommand cmd) {
        SchedulerImpl.scheduleDeferredImpl(cmd);
    }

    @Override
    public void scheduleFinally(Scheduler.ScheduledCommand cmd) {
        SchedulerImpl.scheduleFinallyImpl(cmd);
    }

    @Override
    public void scheduleFixedDelay(Scheduler.RepeatingCommand cmd, int delayMs) {
        SchedulerImpl.scheduleFixedDelayImpl(cmd, delayMs);
    }

    @Override
    public void scheduleFixedPeriod(Scheduler.RepeatingCommand cmd, int delayMs) {
        SchedulerImpl.scheduleFixedPeriodImpl(cmd, delayMs);
    }

    @Override
    public void scheduleIncremental(Scheduler.RepeatingCommand cmd) {
        SchedulerImpl.scheduleIncrementalImpl(cmd);
    }

    static final class Task
    extends JavaScriptObject {
        public static native Task create(Scheduler.RepeatingCommand var0);

        public static native Task create(Scheduler.ScheduledCommand var0);

        protected Task() {
        }

        public boolean executeRepeating() {
            return this.getRepeating().execute();
        }

        public void executeScheduled() {
            this.getScheduled().execute();
        }

        private native Scheduler.RepeatingCommand getRepeating();

        private native Scheduler.ScheduledCommand getScheduled();

        private native boolean isRepeating();
    }
}

