/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.ext.ResourceContext;
import java.util.List;

public class Spriter
extends CssModVisitor {
    private final ResourceContext context;
    private final TreeLogger logger;

    public Spriter(TreeLogger logger, ResourceContext context) {
        this.logger = logger.branch(TreeLogger.DEBUG, "Creating image sprite classes");
        this.context = context;
    }

    public void endVisit(CssSprite x, Context ctx) {
        String repeatText;
        JClassType bundleType = this.context.getClientBundleType();
        String functionName = x.getResourceFunction();
        if (functionName == null) {
            this.logger.log(TreeLogger.ERROR, "The @sprite rule " + x.getSelectors() + " must specify the " + "gwt-image" + " property");
            throw new CssCompilerException("No image property specified");
        }
        JMethod imageMethod = null;
        JMethod[] allMethods = bundleType.getOverridableMethods();
        for (int i = 0; imageMethod == null && i < allMethods.length; ++i) {
            JMethod candidate = allMethods[i];
            if (!candidate.getName().equals(functionName) || candidate.getParameters().length != 0) continue;
            imageMethod = candidate;
        }
        if (imageMethod == null) {
            this.logger.log(TreeLogger.ERROR, "Unable to find ImageResource method " + functionName + " in " + bundleType.getQualifiedSourceName());
            throw new CssCompilerException("Cannot find image function");
        }
        JClassType imageResourceType = this.context.getGeneratorContext().getTypeOracle().findType(ImageResource.class.getName());
        assert (imageResourceType != null);
        if (!imageResourceType.isAssignableFrom(imageMethod.getReturnType().isClassOrInterface())) {
            this.logger.log(TreeLogger.ERROR, "The return type of " + functionName + " is not assignable to " + imageResourceType.getSimpleSourceName());
            throw new CssCompilerException("Incorrect return type for gwt-image method");
        }
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)imageMethod.getAnnotation(ImageResource.ImageOptions.class);
        ImageResource.RepeatStyle repeatStyle = options != null ? options.repeatStyle() : ImageResource.RepeatStyle.None;
        String instance = "(" + this.context.getImplementationSimpleSourceName() + ".this." + functionName + "())";
        CssRule replacement = new CssRule();
        replacement.getSelectors().addAll(x.getSelectors());
        List<CssProperty> properties = replacement.getProperties();
        if (repeatStyle == ImageResource.RepeatStyle.None || repeatStyle == ImageResource.RepeatStyle.Horizontal) {
            properties.add(new CssProperty("height", new CssProperty.ExpressionValue(instance + ".getHeight() + \"px\""), false));
        }
        if (repeatStyle == ImageResource.RepeatStyle.None || repeatStyle == ImageResource.RepeatStyle.Vertical) {
            properties.add(new CssProperty("width", new CssProperty.ExpressionValue(instance + ".getWidth() + \"px\""), false));
        }
        properties.add(new CssProperty("overflow", new CssProperty.IdentValue("hidden"), false));
        switch (repeatStyle) {
            case None: {
                repeatText = " no-repeat";
                break;
            }
            case Horizontal: {
                repeatText = " repeat-x";
                break;
            }
            case Vertical: {
                repeatText = " repeat-y";
                break;
            }
            case Both: {
                repeatText = " repeat";
                break;
            }
            default: {
                throw new RuntimeException("Unknown repeatStyle " + (Object)((Object)repeatStyle));
            }
        }
        String backgroundExpression = "\"url(\\\"\" + " + instance + ".getURL() + \"\\\") -\" + " + instance + ".getLeft() + \"px -\" + " + instance + ".getTop() + \"px " + repeatText + "\"";
        properties.add(new CssProperty("background", new CssProperty.ExpressionValue(backgroundExpression), false));
        properties.addAll(x.getProperties());
        ctx.replaceMe(replacement);
    }
}

