/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "hi" locale.
 */
public class LocalizedNamesImpl_hi extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AO",
        "AQ",
        "AZ",
        "AF",
        "AS",
        "AW",
        "AR",
        "SV",
        "DZ",
        "AL",
        "AC",
        "IM",
        "IS",
        "QO",
        "IE",
        "AM",
        "ID",
        "EC",
        "GQ",
        "IT",
        "ET",
        "IQ",
        "ER",
        "IL",
        "IR",
        "UZ",
        "KP",
        "MP",
        "UY",
        "AI",
        "AG",
        "AD",
        "AX",
        "EE",
        "OM",
        "AT",
        "AU",
        "KH",
        "KZ",
        "CA",
        "KI",
        "KG",
        "CK",
        "KW",
        "KE",
        "CV",
        "KY",
        "IC",
        "CM",
        "BQ",
        "CD",
        "CG",
        "CC",
        "CI",
        "KM",
        "CO",
        "XK",
        "CR",
        "CU",
        "CW",
        "CX",
        "HR",
        "CP",
        "QA",
        "GG",
        "GM",
        "GN",
        "GW",
        "GU",
        "GY",
        "GA",
        "GL",
        "GD",
        "GT",
        "GP",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JM",
        "DE",
        "JE",
        "JP",
        "DJ",
        "GI",
        "GE",
        "JO",
        "ZM",
        "ZW",
        "TO",
        "TG",
        "TN",
        "DG",
        "DK",
        "DO",
        "DM",
        "TZ",
        "TW",
        "TJ",
        "TL",
        "TC",
        "TM",
        "TR",
        "TV",
        "TK",
        "TT",
        "TA",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NE",
        "NG",
        "NR",
        "NA",
        "NI",
        "NL",
        "AN",
        "NU",
        "NP",
        "NF",
        "NO",
        "NC",
        "NZ",
        "PA",
        "PW",
        "EH",
        "PK",
        "PG",
        "PN",
        "PT",
        "PY",
        "PE",
        "PR",
        "PL",
        "FJ",
        "FI",
        "PH",
        "PS",
        "FO",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "BM",
        "BH",
        "BS",
        "BD",
        "BB",
        "BI",
        "BF",
        "BG",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BW",
        "BO",
        "BV",
        "BA",
        "BR",
        "VG",
        "IO",
        "BN",
        "IN",
        "BT",
        "MN",
        "MO",
        "CF",
        "MW",
        "MY",
        "FM",
        "YT",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MT",
        "EG",
        "MG",
        "MX",
        "MK",
        "MS",
        "ME",
        "MZ",
        "MC",
        "MA",
        "MR",
        "MU",
        "MD",
        "MM",
        "YE",
        "UG",
        "UM",
        "VI",
        "UA",
        "GB",
        "GR",
        "EU",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "VU",
        "WF",
        "VN",
        "VA",
        "VE",
        "LK",
        "AE",
        "US",
        "SA",
        "WS",
        "RS",
        "CY",
        "ST",
        "SG",
        "SX",
        "SL",
        "SY",
        "SD",
        "SR",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "EA",
        "SN",
        "SC",
        "SM",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HK",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "विश्व");
    namesMap.put("002", "अफ़्रीका");
    namesMap.put("003", "उत्तर अमेरिका");
    namesMap.put("005", "दक्षिण अमेरिका");
    namesMap.put("009", "ओशिआनिया");
    namesMap.put("011", "पश्चिमी अफ़्रीका");
    namesMap.put("013", "मध्य अमेरिका");
    namesMap.put("014", "पूर्वी अफ़्रीका");
    namesMap.put("015", "उत्तरी अफ़्रीका");
    namesMap.put("017", "मध्य अफ़्रीका");
    namesMap.put("018", "दक्षिणी अफ़्रीका");
    namesMap.put("019", "अमेरिकाज़");
    namesMap.put("021", "उत्तरी अमेरिका");
    namesMap.put("029", "कैरिबीयन");
    namesMap.put("030", "पूर्वी एशिया");
    namesMap.put("034", "दक्षिणी एशिया");
    namesMap.put("035", "दक्षिण-पूर्व एशिया");
    namesMap.put("039", "दक्षिणी यूरोप");
    namesMap.put("053", "ऑस्ट्रेलेशिया");
    namesMap.put("054", "मेलानेशिया");
    namesMap.put("057", "माइक्रोनेशियाई क्षेत्र");
    namesMap.put("061", "पोलीनेशिया");
    namesMap.put("142", "एशिया");
    namesMap.put("143", "मध्य एशिया");
    namesMap.put("145", "पश्चिमी एशिया");
    namesMap.put("150", "यूरोप");
    namesMap.put("151", "पूर्वी यूरोप");
    namesMap.put("154", "उत्तरी यूरोप");
    namesMap.put("155", "पश्चिमी यूरोप");
    namesMap.put("419", "लैटिन अमेरिका");
    namesMap.put("AC", "असेंशन द्वीप");
    namesMap.put("AD", "एंडोरा");
    namesMap.put("AE", "संयुक्त अरब अमीरात");
    namesMap.put("AF", "अफ़गानिस्तान");
    namesMap.put("AG", "एंटिगुआ और बरबुडा");
    namesMap.put("AI", "एंग्विला");
    namesMap.put("AL", "अल्बानिया");
    namesMap.put("AM", "आर्मेनिया");
    namesMap.put("AN", "नीदरलैंडी ऐंटील");
    namesMap.put("AO", "अंगोला");
    namesMap.put("AQ", "अंटार्कटिका");
    namesMap.put("AR", "अर्जेंटीना");
    namesMap.put("AS", "अमेरिकी समोआ");
    namesMap.put("AT", "ऑस्ट्रिया");
    namesMap.put("AU", "ऑस्ट्रेलिया");
    namesMap.put("AW", "अरूबा");
    namesMap.put("AX", "एलैंड द्वीपसमूह");
    namesMap.put("AZ", "अज़रबैजान");
    namesMap.put("BA", "बोस्निया और हर्ज़ेगोविना");
    namesMap.put("BB", "बारबाडोस");
    namesMap.put("BD", "बांग्लादेश");
    namesMap.put("BE", "बेल्जियम");
    namesMap.put("BF", "बुर्किना फ़ासो");
    namesMap.put("BG", "बुल्गारिया");
    namesMap.put("BH", "बहरीन");
    namesMap.put("BI", "बुरुंडी");
    namesMap.put("BJ", "बेनिन");
    namesMap.put("BL", "सेंट बार्थेलेमी");
    namesMap.put("BM", "बरमूडा");
    namesMap.put("BN", "ब्रूनेई");
    namesMap.put("BO", "बोलीविया");
    namesMap.put("BQ", "कैरिबीयाई नीदरलैंड");
    namesMap.put("BR", "ब्राज़ील");
    namesMap.put("BS", "बहामास");
    namesMap.put("BT", "भूटान");
    namesMap.put("BV", "बोवेत द्वीप");
    namesMap.put("BW", "बोत्स्वाना");
    namesMap.put("BY", "बेलारूस");
    namesMap.put("BZ", "बेलीज़");
    namesMap.put("CA", "कनाडा");
    namesMap.put("CC", "कोकोस (कीलिंग) द्वीपसमूह");
    namesMap.put("CD", "कोंगो – किंशासा");
    namesMap.put("CF", "मध्य अफ़्रीकी गणराज्य");
    namesMap.put("CG", "कोंगो – ब्राज़ाविल");
    namesMap.put("CH", "स्विट्ज़रलैंड");
    namesMap.put("CI", "कोट डी आइवर");
    namesMap.put("CK", "कुक द्वीपसमूह");
    namesMap.put("CL", "चिली");
    namesMap.put("CM", "कैमरून");
    namesMap.put("CN", "चीन");
    namesMap.put("CO", "कोलंबिया");
    namesMap.put("CP", "क्लिपर्टन द्वीप");
    namesMap.put("CR", "कोस्टारिका");
    namesMap.put("CU", "क्यूबा");
    namesMap.put("CV", "केप वर्ड");
    namesMap.put("CW", "क्यूरासाओ");
    namesMap.put("CX", "क्रिसमस द्वीप");
    namesMap.put("CY", "साइप्रस");
    namesMap.put("CZ", "चेक गणराज्य");
    namesMap.put("DE", "जर्मनी");
    namesMap.put("DG", "डिएगो गार्सिया");
    namesMap.put("DJ", "जिबूती");
    namesMap.put("DK", "डेनमार्क");
    namesMap.put("DM", "डोमिनिका");
    namesMap.put("DO", "डोमिनिकन गणराज्य");
    namesMap.put("DZ", "अल्जीरिया");
    namesMap.put("EA", "सेउटा और मेलिला");
    namesMap.put("EC", "इक्वाडोर");
    namesMap.put("EE", "एस्टोनिया");
    namesMap.put("EG", "मिस्र");
    namesMap.put("EH", "पश्चिमी सहारा");
    namesMap.put("ER", "इरिट्रिया");
    namesMap.put("ES", "स्पेन");
    namesMap.put("ET", "इथियोपिया");
    namesMap.put("EU", "यूरोपीय संघ");
    namesMap.put("FI", "फ़िनलैंड");
    namesMap.put("FJ", "फ़िजी");
    namesMap.put("FK", "फ़ॉकलैंड द्वीपसमूह");
    namesMap.put("FM", "माइक्रोनेशिया");
    namesMap.put("FO", "फ़ेरो द्वीपसमूह");
    namesMap.put("FR", "फ़्रांस");
    namesMap.put("GA", "गैबॉन");
    namesMap.put("GB", "यूनाइटेड किंगडम");
    namesMap.put("GD", "ग्रेनाडा");
    namesMap.put("GE", "जॉर्जिया");
    namesMap.put("GF", "फ़्रेंच गुयाना");
    namesMap.put("GG", "गर्नसी");
    namesMap.put("GH", "घाना");
    namesMap.put("GI", "जिब्राल्टर");
    namesMap.put("GL", "ग्रीनलैंड");
    namesMap.put("GM", "गाम्बिया");
    namesMap.put("GN", "गिनी");
    namesMap.put("GP", "ग्वाडेलूप");
    namesMap.put("GQ", "इक्वेटोरियल गिनी");
    namesMap.put("GR", "यूनान");
    namesMap.put("GS", "दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह");
    namesMap.put("GT", "ग्वाटेमाला");
    namesMap.put("GU", "गुआम");
    namesMap.put("GW", "गिनी-बिसाउ");
    namesMap.put("GY", "गुयाना");
    namesMap.put("HK", "हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)");
    namesMap.put("HM", "हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह");
    namesMap.put("HN", "होंडूरास");
    namesMap.put("HR", "क्रोएशिया");
    namesMap.put("HT", "हैती");
    namesMap.put("HU", "हंगरी");
    namesMap.put("IC", "कैनेरी द्वीपसमूह");
    namesMap.put("ID", "इंडोनेशिया");
    namesMap.put("IE", "आयरलैंड");
    namesMap.put("IL", "इसराइल");
    namesMap.put("IM", "आइल ऑफ़ मैन");
    namesMap.put("IN", "भारत");
    namesMap.put("IO", "ब्रिटिश हिंद महासागरीय क्षेत्र");
    namesMap.put("IQ", "इराक");
    namesMap.put("IR", "ईरान");
    namesMap.put("IS", "आइसलैंड");
    namesMap.put("IT", "इटली");
    namesMap.put("JE", "जर्सी");
    namesMap.put("JM", "जमैका");
    namesMap.put("JO", "जॉर्डन");
    namesMap.put("JP", "जापान");
    namesMap.put("KE", "केन्या");
    namesMap.put("KG", "किर्गिज़स्तान");
    namesMap.put("KH", "कंबोडिया");
    namesMap.put("KI", "किरिबाती");
    namesMap.put("KM", "कोमोरोस");
    namesMap.put("KN", "सेंट किट्स और नेविस");
    namesMap.put("KP", "उत्तर कोरिया");
    namesMap.put("KR", "दक्षिण कोरिया");
    namesMap.put("KW", "कुवैत");
    namesMap.put("KY", "केमैन द्वीपसमूह");
    namesMap.put("KZ", "कज़ाखस्तान");
    namesMap.put("LA", "लाओस");
    namesMap.put("LB", "लेबनान");
    namesMap.put("LC", "सेंट लूसिया");
    namesMap.put("LI", "लिचेंस्टीन");
    namesMap.put("LK", "श्रीलंका");
    namesMap.put("LR", "लाइबेरिया");
    namesMap.put("LS", "लेसोथो");
    namesMap.put("LT", "लिथुआनिया");
    namesMap.put("LU", "लग्ज़मबर्ग");
    namesMap.put("LV", "लातविया");
    namesMap.put("LY", "लीबिया");
    namesMap.put("MA", "मोरक्को");
    namesMap.put("MC", "मोनाको");
    namesMap.put("MD", "मॉल्डोवा");
    namesMap.put("ME", "मोंटेनेग्रो");
    namesMap.put("MF", "सेंट मार्टिन");
    namesMap.put("MG", "मेडागास्कर");
    namesMap.put("MH", "मार्शल द्वीपसमूह");
    namesMap.put("MK", "मैसिडोनिया");
    namesMap.put("ML", "माली");
    namesMap.put("MM", "म्यांमार (बर्मा)");
    namesMap.put("MN", "मंगोलिया");
    namesMap.put("MO", "मकाओ (चीन विशेष प्रशासनिक क्षेत्र)");
    namesMap.put("MP", "उत्तरी मारियाना द्वीपसमूह");
    namesMap.put("MQ", "मार्टीनिक");
    namesMap.put("MR", "मॉरिटानिया");
    namesMap.put("MS", "मोंटसेरात");
    namesMap.put("MT", "माल्टा");
    namesMap.put("MU", "मॉरिशस");
    namesMap.put("MV", "मालदीव");
    namesMap.put("MW", "मलावी");
    namesMap.put("MX", "मैक्सिको");
    namesMap.put("MY", "मलेशिया");
    namesMap.put("MZ", "मोज़ांबिक");
    namesMap.put("NA", "नामीबिया");
    namesMap.put("NC", "न्यू कैलेडोनिया");
    namesMap.put("NE", "नाइजर");
    namesMap.put("NF", "नॉरफ़ॉक द्वीप");
    namesMap.put("NG", "नाइजीरिया");
    namesMap.put("NI", "निकारागुआ");
    namesMap.put("NL", "नीदरलैंड");
    namesMap.put("NO", "नॉर्वे");
    namesMap.put("NP", "नेपाल");
    namesMap.put("NR", "नाउरु");
    namesMap.put("NU", "नीयू");
    namesMap.put("NZ", "न्यूज़ीलैंड");
    namesMap.put("OM", "ओमान");
    namesMap.put("PA", "पनामा");
    namesMap.put("PE", "पेरू");
    namesMap.put("PF", "फ़्रेंच पोलिनेशिया");
    namesMap.put("PG", "पापुआ न्यू गिनी");
    namesMap.put("PH", "फ़िलिपींस");
    namesMap.put("PK", "पाकिस्तान");
    namesMap.put("PL", "पोलैंड");
    namesMap.put("PM", "सेंट पिएरे और मिक्वेलान");
    namesMap.put("PN", "पिटकैर्न द्वीपसमूह");
    namesMap.put("PR", "पोर्टो रिको");
    namesMap.put("PS", "फ़िलिस्तीनी क्षेत्र");
    namesMap.put("PT", "पुर्तगाल");
    namesMap.put("PW", "पलाऊ");
    namesMap.put("PY", "पेराग्वे");
    namesMap.put("QA", "क़तर");
    namesMap.put("QO", "आउटलाइंग ओशिनिया");
    namesMap.put("RE", "रियूनियन");
    namesMap.put("RO", "रोमानिया");
    namesMap.put("RS", "सर्बिया");
    namesMap.put("RU", "रूस");
    namesMap.put("RW", "रवांडा");
    namesMap.put("SA", "सऊदी अरब");
    namesMap.put("SB", "सोलोमन द्वीपसमूह");
    namesMap.put("SC", "सेशेल्स");
    namesMap.put("SD", "सूडान");
    namesMap.put("SE", "स्वीडन");
    namesMap.put("SG", "सिंगापुर");
    namesMap.put("SH", "सेंट हेलेना");
    namesMap.put("SI", "स्लोवेनिया");
    namesMap.put("SJ", "स्वालबार्ड और जान मायेन");
    namesMap.put("SK", "स्लोवाकिया");
    namesMap.put("SL", "सिएरा लियोन");
    namesMap.put("SM", "सैन मेरीनो");
    namesMap.put("SN", "सेनेगल");
    namesMap.put("SO", "सोमालिया");
    namesMap.put("SR", "सूरीनाम");
    namesMap.put("SS", "दक्षिण सूडान");
    namesMap.put("ST", "साओ टोम और प्रिंसिपे");
    namesMap.put("SV", "अल सल्वाडोर");
    namesMap.put("SX", "सिंट मार्टिन");
    namesMap.put("SY", "सीरिया");
    namesMap.put("SZ", "स्वाज़ीलैंड");
    namesMap.put("TA", "त्रिस्टान डा कुना");
    namesMap.put("TC", "तुर्क और कैकोज़ द्वीपसमूह");
    namesMap.put("TD", "चाड");
    namesMap.put("TF", "फ़्रांसीसी दक्षिणी क्षेत्र");
    namesMap.put("TG", "टोगो");
    namesMap.put("TH", "थाईलैंड");
    namesMap.put("TJ", "ताजिकिस्तान");
    namesMap.put("TK", "तोकेलाउ");
    namesMap.put("TL", "तिमोर-लेस्त");
    namesMap.put("TM", "तुर्कमेनिस्तान");
    namesMap.put("TN", "ट्यूनीशिया");
    namesMap.put("TO", "टोंगा");
    namesMap.put("TR", "तुर्की");
    namesMap.put("TT", "त्रिनिडाड और टोबैगो");
    namesMap.put("TV", "तुवालू");
    namesMap.put("TW", "ताइवान");
    namesMap.put("TZ", "तंज़ानिया");
    namesMap.put("UA", "यूक्रेन");
    namesMap.put("UG", "युगांडा");
    namesMap.put("UM", "यू.एस. आउटलाइंग द्वीपसमूह");
    namesMap.put("US", "संयुक्त राज्य");
    namesMap.put("UY", "उरूग्वे");
    namesMap.put("UZ", "उज़्बेकिस्तान");
    namesMap.put("VA", "वेटिकन सिटी");
    namesMap.put("VC", "सेंट विंसेंट एंड ग्रेनाडाइंस");
    namesMap.put("VE", "वेनेज़ुएला");
    namesMap.put("VG", "ब्रिटिश वर्जिन द्वीपसमूह");
    namesMap.put("VI", "यू.एस. वर्जिन द्वीपसमूह");
    namesMap.put("VN", "वियतनाम");
    namesMap.put("VU", "वनुआतू");
    namesMap.put("WF", "वालिस और फ़्यूचूना");
    namesMap.put("WS", "समोआ");
    namesMap.put("XK", "कोसोवो");
    namesMap.put("YE", "यमन");
    namesMap.put("YT", "मायोते");
    namesMap.put("ZA", "दक्षिण अफ़्रीका");
    namesMap.put("ZM", "ज़ाम्बिया");
    namesMap.put("ZW", "ज़िम्बाब्वे");
    namesMap.put("ZZ", "अज्ञात क्षेत्र");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "विश्व",
        "002": "अफ़्रीका",
        "003": "उत्तर अमेरिका",
        "005": "दक्षिण अमेरिका",
        "009": "ओशिआनिया",
        "011": "पश्चिमी अफ़्रीका",
        "013": "मध्य अमेरिका",
        "014": "पूर्वी अफ़्रीका",
        "015": "उत्तरी अफ़्रीका",
        "017": "मध्य अफ़्रीका",
        "018": "दक्षिणी अफ़्रीका",
        "019": "अमेरिकाज़",
        "021": "उत्तरी अमेरिका",
        "029": "कैरिबीयन",
        "030": "पूर्वी एशिया",
        "034": "दक्षिणी एशिया",
        "035": "दक्षिण-पूर्व एशिया",
        "039": "दक्षिणी यूरोप",
        "053": "ऑस्ट्रेलेशिया",
        "054": "मेलानेशिया",
        "057": "माइक्रोनेशियाई क्षेत्र",
        "061": "पोलीनेशिया",
        "142": "एशिया",
        "143": "मध्य एशिया",
        "145": "पश्चिमी एशिया",
        "150": "यूरोप",
        "151": "पूर्वी यूरोप",
        "154": "उत्तरी यूरोप",
        "155": "पश्चिमी यूरोप",
        "419": "लैटिन अमेरिका",
        "AC": "असेंशन द्वीप",
        "AD": "एंडोरा",
        "AE": "संयुक्त अरब अमीरात",
        "AF": "अफ़गानिस्तान",
        "AG": "एंटिगुआ और बरबुडा",
        "AI": "एंग्विला",
        "AL": "अल्बानिया",
        "AM": "आर्मेनिया",
        "AN": "नीदरलैंडी ऐंटील",
        "AO": "अंगोला",
        "AQ": "अंटार्कटिका",
        "AR": "अर्जेंटीना",
        "AS": "अमेरिकी समोआ",
        "AT": "ऑस्ट्रिया",
        "AU": "ऑस्ट्रेलिया",
        "AW": "अरूबा",
        "AX": "एलैंड द्वीपसमूह",
        "AZ": "अज़रबैजान",
        "BA": "बोस्निया और हर्ज़ेगोविना",
        "BB": "बारबाडोस",
        "BD": "बांग्लादेश",
        "BE": "बेल्जियम",
        "BF": "बुर्किना फ़ासो",
        "BG": "बुल्गारिया",
        "BH": "बहरीन",
        "BI": "बुरुंडी",
        "BJ": "बेनिन",
        "BL": "सेंट बार्थेलेमी",
        "BM": "बरमूडा",
        "BN": "ब्रूनेई",
        "BO": "बोलीविया",
        "BQ": "कैरिबीयाई नीदरलैंड",
        "BR": "ब्राज़ील",
        "BS": "बहामास",
        "BT": "भूटान",
        "BV": "बोवेत द्वीप",
        "BW": "बोत्स्वाना",
        "BY": "बेलारूस",
        "BZ": "बेलीज़",
        "CA": "कनाडा",
        "CC": "कोकोस (कीलिंग) द्वीपसमूह",
        "CD": "कोंगो – किंशासा",
        "CF": "मध्य अफ़्रीकी गणराज्य",
        "CG": "कोंगो – ब्राज़ाविल",
        "CH": "स्विट्ज़रलैंड",
        "CI": "कोट डी आइवर",
        "CK": "कुक द्वीपसमूह",
        "CL": "चिली",
        "CM": "कैमरून",
        "CN": "चीन",
        "CO": "कोलंबिया",
        "CP": "क्लिपर्टन द्वीप",
        "CR": "कोस्टारिका",
        "CU": "क्यूबा",
        "CV": "केप वर्ड",
        "CW": "क्यूरासाओ",
        "CX": "क्रिसमस द्वीप",
        "CY": "साइप्रस",
        "CZ": "चेक गणराज्य",
        "DE": "जर्मनी",
        "DG": "डिएगो गार्सिया",
        "DJ": "जिबूती",
        "DK": "डेनमार्क",
        "DM": "डोमिनिका",
        "DO": "डोमिनिकन गणराज्य",
        "DZ": "अल्जीरिया",
        "EA": "सेउटा और मेलिला",
        "EC": "इक्वाडोर",
        "EE": "एस्टोनिया",
        "EG": "मिस्र",
        "EH": "पश्चिमी सहारा",
        "ER": "इरिट्रिया",
        "ES": "स्पेन",
        "ET": "इथियोपिया",
        "EU": "यूरोपीय संघ",
        "FI": "फ़िनलैंड",
        "FJ": "फ़िजी",
        "FK": "फ़ॉकलैंड द्वीपसमूह",
        "FM": "माइक्रोनेशिया",
        "FO": "फ़ेरो द्वीपसमूह",
        "FR": "फ़्रांस",
        "GA": "गैबॉन",
        "GB": "यूनाइटेड किंगडम",
        "GD": "ग्रेनाडा",
        "GE": "जॉर्जिया",
        "GF": "फ़्रेंच गुयाना",
        "GG": "गर्नसी",
        "GH": "घाना",
        "GI": "जिब्राल्टर",
        "GL": "ग्रीनलैंड",
        "GM": "गाम्बिया",
        "GN": "गिनी",
        "GP": "ग्वाडेलूप",
        "GQ": "इक्वेटोरियल गिनी",
        "GR": "यूनान",
        "GS": "दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह",
        "GT": "ग्वाटेमाला",
        "GU": "गुआम",
        "GW": "गिनी-बिसाउ",
        "GY": "गुयाना",
        "HK": "हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)",
        "HM": "हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह",
        "HN": "होंडूरास",
        "HR": "क्रोएशिया",
        "HT": "हैती",
        "HU": "हंगरी",
        "IC": "कैनेरी द्वीपसमूह",
        "ID": "इंडोनेशिया",
        "IE": "आयरलैंड",
        "IL": "इसराइल",
        "IM": "आइल ऑफ़ मैन",
        "IN": "भारत",
        "IO": "ब्रिटिश हिंद महासागरीय क्षेत्र",
        "IQ": "इराक",
        "IR": "ईरान",
        "IS": "आइसलैंड",
        "IT": "इटली",
        "JE": "जर्सी",
        "JM": "जमैका",
        "JO": "जॉर्डन",
        "JP": "जापान",
        "KE": "केन्या",
        "KG": "किर्गिज़स्तान",
        "KH": "कंबोडिया",
        "KI": "किरिबाती",
        "KM": "कोमोरोस",
        "KN": "सेंट किट्स और नेविस",
        "KP": "उत्तर कोरिया",
        "KR": "दक्षिण कोरिया",
        "KW": "कुवैत",
        "KY": "केमैन द्वीपसमूह",
        "KZ": "कज़ाखस्तान",
        "LA": "लाओस",
        "LB": "लेबनान",
        "LC": "सेंट लूसिया",
        "LI": "लिचेंस्टीन",
        "LK": "श्रीलंका",
        "LR": "लाइबेरिया",
        "LS": "लेसोथो",
        "LT": "लिथुआनिया",
        "LU": "लग्ज़मबर्ग",
        "LV": "लातविया",
        "LY": "लीबिया",
        "MA": "मोरक्को",
        "MC": "मोनाको",
        "MD": "मॉल्डोवा",
        "ME": "मोंटेनेग्रो",
        "MF": "सेंट मार्टिन",
        "MG": "मेडागास्कर",
        "MH": "मार्शल द्वीपसमूह",
        "MK": "मैसिडोनिया",
        "ML": "माली",
        "MM": "म्यांमार (बर्मा)",
        "MN": "मंगोलिया",
        "MO": "मकाओ (चीन विशेष प्रशासनिक क्षेत्र)",
        "MP": "उत्तरी मारियाना द्वीपसमूह",
        "MQ": "मार्टीनिक",
        "MR": "मॉरिटानिया",
        "MS": "मोंटसेरात",
        "MT": "माल्टा",
        "MU": "मॉरिशस",
        "MV": "मालदीव",
        "MW": "मलावी",
        "MX": "मैक्सिको",
        "MY": "मलेशिया",
        "MZ": "मोज़ांबिक",
        "NA": "नामीबिया",
        "NC": "न्यू कैलेडोनिया",
        "NE": "नाइजर",
        "NF": "नॉरफ़ॉक द्वीप",
        "NG": "नाइजीरिया",
        "NI": "निकारागुआ",
        "NL": "नीदरलैंड",
        "NO": "नॉर्वे",
        "NP": "नेपाल",
        "NR": "नाउरु",
        "NU": "नीयू",
        "NZ": "न्यूज़ीलैंड",
        "OM": "ओमान",
        "PA": "पनामा",
        "PE": "पेरू",
        "PF": "फ़्रेंच पोलिनेशिया",
        "PG": "पापुआ न्यू गिनी",
        "PH": "फ़िलिपींस",
        "PK": "पाकिस्तान",
        "PL": "पोलैंड",
        "PM": "सेंट पिएरे और मिक्वेलान",
        "PN": "पिटकैर्न द्वीपसमूह",
        "PR": "पोर्टो रिको",
        "PS": "फ़िलिस्तीनी क्षेत्र",
        "PT": "पुर्तगाल",
        "PW": "पलाऊ",
        "PY": "पेराग्वे",
        "QA": "क़तर",
        "QO": "आउटलाइंग ओशिनिया",
        "RE": "रियूनियन",
        "RO": "रोमानिया",
        "RS": "सर्बिया",
        "RU": "रूस",
        "RW": "रवांडा",
        "SA": "सऊदी अरब",
        "SB": "सोलोमन द्वीपसमूह",
        "SC": "सेशेल्स",
        "SD": "सूडान",
        "SE": "स्वीडन",
        "SG": "सिंगापुर",
        "SH": "सेंट हेलेना",
        "SI": "स्लोवेनिया",
        "SJ": "स्वालबार्ड और जान मायेन",
        "SK": "स्लोवाकिया",
        "SL": "सिएरा लियोन",
        "SM": "सैन मेरीनो",
        "SN": "सेनेगल",
        "SO": "सोमालिया",
        "SR": "सूरीनाम",
        "SS": "दक्षिण सूडान",
        "ST": "साओ टोम और प्रिंसिपे",
        "SV": "अल सल्वाडोर",
        "SX": "सिंट मार्टिन",
        "SY": "सीरिया",
        "SZ": "स्वाज़ीलैंड",
        "TA": "त्रिस्टान डा कुना",
        "TC": "तुर्क और कैकोज़ द्वीपसमूह",
        "TD": "चाड",
        "TF": "फ़्रांसीसी दक्षिणी क्षेत्र",
        "TG": "टोगो",
        "TH": "थाईलैंड",
        "TJ": "ताजिकिस्तान",
        "TK": "तोकेलाउ",
        "TL": "तिमोर-लेस्त",
        "TM": "तुर्कमेनिस्तान",
        "TN": "ट्यूनीशिया",
        "TO": "टोंगा",
        "TR": "तुर्की",
        "TT": "त्रिनिडाड और टोबैगो",
        "TV": "तुवालू",
        "TW": "ताइवान",
        "TZ": "तंज़ानिया",
        "UA": "यूक्रेन",
        "UG": "युगांडा",
        "UM": "यू.एस. आउटलाइंग द्वीपसमूह",
        "US": "संयुक्त राज्य",
        "UY": "उरूग्वे",
        "UZ": "उज़्बेकिस्तान",
        "VA": "वेटिकन सिटी",
        "VC": "सेंट विंसेंट एंड ग्रेनाडाइंस",
        "VE": "वेनेज़ुएला",
        "VG": "ब्रिटिश वर्जिन द्वीपसमूह",
        "VI": "यू.एस. वर्जिन द्वीपसमूह",
        "VN": "वियतनाम",
        "VU": "वनुआतू",
        "WF": "वालिस और फ़्यूचूना",
        "WS": "समोआ",
        "XK": "कोसोवो",
        "YE": "यमन",
        "YT": "मायोते",
        "ZA": "दक्षिण अफ़्रीका",
        "ZM": "ज़ाम्बिया",
        "ZW": "ज़िम्बाब्वे",
        "ZZ": "अज्ञात क्षेत्र"
    };
  }-*/;
}
