/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "luo" locale.
 */
public class LocalizedNamesImpl_luo extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "KE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "BV",
        "KH",
        "CM",
        "CA",
        "CV",
        "KY",
        "CC",
        "CF",
        "TD",
        "CL",
        "CN",
        "FK",
        "MH",
        "NF",
        "CO",
        "KM",
        "CG",
        "CK",
        "CR",
        "CI",
        "CP",
        "HR",
        "CU",
        "CW",
        "CX",
        "CY",
        "CZ",
        "CD",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EA",
        "TL",
        "EC",
        "EG",
        "EH",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FJ",
        "FI",
        "FO",
        "FR",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "DE",
        "GG",
        "GH",
        "GI",
        "GR",
        "GL",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "GY",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IS",
        "IM",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KI",
        "KP",
        "KR",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "MP",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SB",
        "SO",
        "ZA",
        "ES",
        "LK",
        "SS",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SY",
        "TA",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "UM",
        "AE",
        "GB",
        "UY",
        "US",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XK",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AG", "Antigua gi Barbuda");
    namesMap.put("BA", "Bosnia gi Herzegovina");
    namesMap.put("CD", "Democratic Republic of the Congo");
    namesMap.put("CG", "Congo");
    namesMap.put("CI", "Côte d");
    namesMap.put("CV", "Cape Verde Islands");
    namesMap.put("FK", "Chuia mar Falkland");
    namesMap.put("KN", "Saint Kitts gi Nevis");
    namesMap.put("KP", "Korea Masawa");
    namesMap.put("KR", "Korea Milambo");
    namesMap.put("MH", "Chuia mar Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("NF", "Chuia mar Norfolk");
    namesMap.put("PM", "Saint Pierre gi Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinian West Bank gi Gaza");
    namesMap.put("ST", "São Tomé gi Príncipe");
    namesMap.put("TC", "Turks gi Caicos Islands");
    namesMap.put("TL", "East Timor");
    namesMap.put("TT", "Trinidad gi Tobago");
    namesMap.put("US", "USA");
    namesMap.put("VA", "Vatican State");
    namesMap.put("VC", "Saint Vincent gi Grenadines");
    namesMap.put("WF", "Wallis gi Futuna");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AG": "Antigua gi Barbuda",
        "BA": "Bosnia gi Herzegovina",
        "CD": "Democratic Republic of the Congo",
        "CG": "Congo",
        "CI": "Côte d",
        "CV": "Cape Verde Islands",
        "FK": "Chuia mar Falkland",
        "KN": "Saint Kitts gi Nevis",
        "KP": "Korea Masawa",
        "KR": "Korea Milambo",
        "MH": "Chuia mar Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "NF": "Chuia mar Norfolk",
        "PM": "Saint Pierre gi Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestinian West Bank gi Gaza",
        "ST": "São Tomé gi Príncipe",
        "TC": "Turks gi Caicos Islands",
        "TL": "East Timor",
        "TT": "Trinidad gi Tobago",
        "US": "USA",
        "VA": "Vatican State",
        "VC": "Saint Vincent gi Grenadines",
        "WF": "Wallis gi Futuna"
    };
  }-*/;
}
