/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sbp" locale.
 */
public class LocalizedNamesImpl_sbp extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "ZA",
        "AF",
        "AR",
        "DZ",
        "AM",
        "AW",
        "AL",
        "AD",
        "AO",
        "AI",
        "AG",
        "AN",
        "AQ",
        "AZ",
        "AU",
        "AT",
        "AX",
        "IE",
        "IS",
        "BB",
        "BH",
        "BS",
        "BD",
        "BY",
        "BM",
        "BZ",
        "BJ",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BF",
        "MG",
        "BR",
        "BG",
        "BI",
        "BN",
        "BT",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "FK",
        "CK",
        "MP",
        "SB",
        "TC",
        "VI",
        "KY",
        "MH",
        "VG",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GG",
        "GD",
        "GL",
        "GN",
        "GW",
        "GQ",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IQ",
        "IM",
        "IN",
        "ID",
        "IL",
        "IT",
        "JM",
        "CF",
        "DO",
        "CD",
        "CZ",
        "JP",
        "JE",
        "GI",
        "DJ",
        "GE",
        "KH",
        "CM",
        "CA",
        "KZ",
        "QA",
        "KE",
        "CV",
        "GH",
        "KI",
        "KG",
        "CI",
        "HR",
        "KR",
        "KP",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "CY",
        "KW",
        "LU",
        "LV",
        "LA",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "RE",
        "RO",
        "RW",
        "MW",
        "US",
        "MY",
        "ML",
        "MT",
        "MQ",
        "MK",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "EG",
        "MO",
        "MV",
        "MD",
        "MU",
        "MR",
        "MA",
        "MC",
        "MN",
        "MS",
        "PS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PY",
        "PW",
        "PA",
        "PG",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "QO",
        "RS",
        "SM",
        "ZM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "SA",
        "ST",
        "SN",
        "TD",
        "SC",
        "NF",
        "CL",
        "CN",
        "SL",
        "LK",
        "SY",
        "SK",
        "SI",
        "ZW",
        "SG",
        "SJ",
        "SO",
        "SS",
        "SD",
        "SR",
        "SX",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TT",
        "TL",
        "TG",
        "TK",
        "TO",
        "TM",
        "TN",
        "TV",
        "BE",
        "UG",
        "ET",
        "UY",
        "IO",
        "UM",
        "UZ",
        "SZ",
        "SE",
        "CH",
        "TR",
        "IR",
        "GB",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "FR",
        "FI",
        "GR",
        "NL",
        "DE",
        "PT",
        "RU",
        "AE",
        "XK",
        "YE",
        "JO",
        "UA",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andola");
    namesMap.put("AE", "Wutwa wa shiyalabu");
    namesMap.put("AF", "Afuganisitani");
    namesMap.put("AG", "Anitiguya ni Balubuda");
    namesMap.put("AL", "Alubaniya");
    namesMap.put("AM", "Alimeniya");
    namesMap.put("AN", "Anitili sa Uholansi");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoya ya Malekani");
    namesMap.put("AT", "Awusitiliya");
    namesMap.put("AU", "Awusitilaliya");
    namesMap.put("AW", "Aluba");
    namesMap.put("AZ", "Asabajani");
    namesMap.put("BA", "Bosiniya ni Hesegovina");
    namesMap.put("BB", "Babadosi");
    namesMap.put("BD", "Bangiladeshi");
    namesMap.put("BE", "Ubeligiji");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BG", "Buligaliya");
    namesMap.put("BH", "Bahaleni");
    namesMap.put("BI", "Bulundi");
    namesMap.put("BJ", "Benini");
    namesMap.put("BM", "Belimuda");
    namesMap.put("BN", "Buluneyi");
    namesMap.put("BO", "Boliviya");
    namesMap.put("BR", "Bulasili");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butani");
    namesMap.put("BW", "Botiswana");
    namesMap.put("BY", "Belalusi");
    namesMap.put("BZ", "Belise");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Jamuhuli ya Kidemokilasiya ya Kongo");
    namesMap.put("CF", "Jamuhuli ya Afilika ya Pakhati");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Uswisi");
    namesMap.put("CI", "Kodivaya");
    namesMap.put("CK", "Figunguli fya Kooki");
    namesMap.put("CL", "Shile");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CN", "Shina");
    namesMap.put("CO", "Kolombiya");
    namesMap.put("CR", "Kositalika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kepuvede");
    namesMap.put("CY", "Kupilosi");
    namesMap.put("CZ", "Jamuhuli ya Sheki");
    namesMap.put("DE", "Wujelumani");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Denimaki");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamuhuli ya Dominika");
    namesMap.put("DZ", "Alijeliya");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EE", "Esitoniya");
    namesMap.put("EG", "Misili");
    namesMap.put("ER", "Elitileya");
    namesMap.put("ES", "Hisipaniya");
    namesMap.put("ET", "Uhabeshi");
    namesMap.put("FI", "Wufini");
    namesMap.put("FK", "Figunguli fya Fokolendi");
    namesMap.put("FM", "Mikilonesiya");
    namesMap.put("FR", "Wufalansa");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Uwingelesa");
    namesMap.put("GD", "Gilenada");
    namesMap.put("GE", "Jojiya");
    namesMap.put("GF", "Gwiyana ya Wufalansa");
    namesMap.put("GH", "Khana");
    namesMap.put("GI", "Jibulalita");
    namesMap.put("GL", "Gilinilandi");
    namesMap.put("GM", "Gambiya");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Ginekweta");
    namesMap.put("GR", "Wugiliki");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwamu");
    namesMap.put("GW", "Ginebisawu");
    namesMap.put("HN", "Hondulasi");
    namesMap.put("HR", "Kolasiya");
    namesMap.put("HT", "Hayiti");
    namesMap.put("HU", "Hungaliya");
    namesMap.put("ID", "Indonesiya");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Isilaeli");
    namesMap.put("IN", "Indiya");
    namesMap.put("IO", "Uluvala lwa Uwingelesa ku Bahali ya Hindi");
    namesMap.put("IQ", "Ilaki");
    namesMap.put("IR", "Uwajemi");
    namesMap.put("IS", "Ayisilendi");
    namesMap.put("IT", "Italiya");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yolodani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kiligisisitani");
    namesMap.put("KH", "Kambodiya");
    namesMap.put("KI", "Kilibati");
    namesMap.put("KM", "Komolo");
    namesMap.put("KN", "Santakitisi ni Nevisi");
    namesMap.put("KP", "Koleya ya luvala lwa Kunyamande");
    namesMap.put("KR", "Koleya ya Kusini");
    namesMap.put("KW", "Kuwaiti");
    namesMap.put("KY", "Figunguli ifya Kayimayi");
    namesMap.put("KZ", "Kasakisitani");
    namesMap.put("LA", "Layosi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Santalusiya");
    namesMap.put("LI", "Lisheniteni");
    namesMap.put("LK", "Sililanka");
    namesMap.put("LR", "Libeliya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwaniya");
    namesMap.put("LU", "Lasembagi");
    namesMap.put("LV", "Lativiya");
    namesMap.put("LY", "Libiya");
    namesMap.put("MA", "Moloko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Molidova");
    namesMap.put("MG", "Bukini");
    namesMap.put("MH", "Figunguli ifya Malishali");
    namesMap.put("MK", "Masedoniya");
    namesMap.put("MM", "Muyama");
    namesMap.put("MN", "Mongoliya");
    namesMap.put("MP", "Figunguli fya Maliyana ifya luvala lwa Kunyamande");
    namesMap.put("MQ", "Malitiniki");
    namesMap.put("MR", "Molitaniya");
    namesMap.put("MS", "Monitiselati");
    namesMap.put("MT", "Malita");
    namesMap.put("MU", "Molisi");
    namesMap.put("MV", "Modivu");
    namesMap.put("MX", "Mekisiko");
    namesMap.put("MY", "Malesiya");
    namesMap.put("MZ", "Musumbiji");
    namesMap.put("NA", "Namibiya");
    namesMap.put("NC", "Nyukaledoniya");
    namesMap.put("NE", "Nijeli");
    namesMap.put("NF", "Shigunguli sha Nolifoki");
    namesMap.put("NG", "Nijeliya");
    namesMap.put("NI", "Nikalagwa");
    namesMap.put("NL", "Wuholansi");
    namesMap.put("NO", "Nolwe");
    namesMap.put("NP", "Nepali");
    namesMap.put("NR", "Nawulu");
    namesMap.put("NU", "Niwue");
    namesMap.put("NZ", "Nyusilendi");
    namesMap.put("OM", "Omani");
    namesMap.put("PE", "Pelu");
    namesMap.put("PF", "Polinesiya ya Wufalansa");
    namesMap.put("PG", "Papuwa");
    namesMap.put("PH", "Filipino");
    namesMap.put("PK", "Pakisitani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Santapieli ni Mikeloni");
    namesMap.put("PN", "Pitikailini");
    namesMap.put("PR", "Pwetoliko");
    namesMap.put("PS", "Munjema gwa Kusikha nu Luvala lwa Gasa lwa Palesit");
    namesMap.put("PT", "Wuleno");
    namesMap.put("PW", "Palawu");
    namesMap.put("PY", "Palagwayi");
    namesMap.put("QA", "Katali");
    namesMap.put("RE", "Liyunioni");
    namesMap.put("RO", "Lomaniya");
    namesMap.put("RU", "Wulusi");
    namesMap.put("RW", "Lwanda");
    namesMap.put("SA", "Sawudi");
    namesMap.put("SB", "Figunguli fya Solomoni");
    namesMap.put("SC", "Shelisheli");
    namesMap.put("SD", "Sudani");
    namesMap.put("SE", "Uswidi");
    namesMap.put("SG", "Singapoo");
    namesMap.put("SH", "Santahelena");
    namesMap.put("SI", "Siloveniya");
    namesMap.put("SK", "Silovakiya");
    namesMap.put("SL", "Siela Liyoni");
    namesMap.put("SM", "Samalino");
    namesMap.put("SN", "Senegali");
    namesMap.put("SO", "Somaliya");
    namesMap.put("SR", "Sulinamu");
    namesMap.put("ST", "Sayo Tome ni Pilinikipe");
    namesMap.put("SV", "Elisavado");
    namesMap.put("SY", "Siliya");
    namesMap.put("SZ", "Uswasi");
    namesMap.put("TC", "Figunguli fya Tuliki ni Kaiko");
    namesMap.put("TD", "Shadi");
    namesMap.put("TH", "Tailandi");
    namesMap.put("TJ", "Tajikisitani");
    namesMap.put("TK", "Tokelawu");
    namesMap.put("TL", "Timoli ya kunena");
    namesMap.put("TM", "Tulukimenisitani");
    namesMap.put("TN", "Tunisiya");
    namesMap.put("TR", "Utuluki");
    namesMap.put("TT", "Tilinidadi ni Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("TZ", "Tansaniya");
    namesMap.put("UA", "Yukileini");
    namesMap.put("US", "Malekani");
    namesMap.put("UY", "Ulugwayi");
    namesMap.put("UZ", "Usibekisitani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Santavisenti na Gilenadini");
    namesMap.put("VE", "Venesuela");
    namesMap.put("VG", "Figunguli ifya Viliginiya ifya Uwingelesa");
    namesMap.put("VI", "Figunguli fya Viliginiya ifya Malekani");
    namesMap.put("VN", "Vietinamu");
    namesMap.put("WF", "Walisi ni Futuna");
    namesMap.put("WS", "Samoya");
    namesMap.put("YE", "Yemeni");
    namesMap.put("YT", "Mayote");
    namesMap.put("ZA", "Afilika Kusini");
    namesMap.put("ZM", "Sambiya");
    namesMap.put("ZW", "Simbabwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andola",
        "AE": "Wutwa wa shiyalabu",
        "AF": "Afuganisitani",
        "AG": "Anitiguya ni Balubuda",
        "AL": "Alubaniya",
        "AM": "Alimeniya",
        "AN": "Anitili sa Uholansi",
        "AR": "Ajentina",
        "AS": "Samoya ya Malekani",
        "AT": "Awusitiliya",
        "AU": "Awusitilaliya",
        "AW": "Aluba",
        "AZ": "Asabajani",
        "BA": "Bosiniya ni Hesegovina",
        "BB": "Babadosi",
        "BD": "Bangiladeshi",
        "BE": "Ubeligiji",
        "BF": "Bukinafaso",
        "BG": "Buligaliya",
        "BH": "Bahaleni",
        "BI": "Bulundi",
        "BJ": "Benini",
        "BM": "Belimuda",
        "BN": "Buluneyi",
        "BO": "Boliviya",
        "BR": "Bulasili",
        "BS": "Bahama",
        "BT": "Butani",
        "BW": "Botiswana",
        "BY": "Belalusi",
        "BZ": "Belise",
        "CA": "Kanada",
        "CD": "Jamuhuli ya Kidemokilasiya ya Kongo",
        "CF": "Jamuhuli ya Afilika ya Pakhati",
        "CG": "Kongo",
        "CH": "Uswisi",
        "CI": "Kodivaya",
        "CK": "Figunguli fya Kooki",
        "CL": "Shile",
        "CM": "Kameruni",
        "CN": "Shina",
        "CO": "Kolombiya",
        "CR": "Kositalika",
        "CU": "Kuba",
        "CV": "Kepuvede",
        "CY": "Kupilosi",
        "CZ": "Jamuhuli ya Sheki",
        "DE": "Wujelumani",
        "DJ": "Jibuti",
        "DK": "Denimaki",
        "DM": "Dominika",
        "DO": "Jamuhuli ya Dominika",
        "DZ": "Alijeliya",
        "EC": "Ekwado",
        "EE": "Esitoniya",
        "EG": "Misili",
        "ER": "Elitileya",
        "ES": "Hisipaniya",
        "ET": "Uhabeshi",
        "FI": "Wufini",
        "FK": "Figunguli fya Fokolendi",
        "FM": "Mikilonesiya",
        "FR": "Wufalansa",
        "GA": "Gaboni",
        "GB": "Uwingelesa",
        "GD": "Gilenada",
        "GE": "Jojiya",
        "GF": "Gwiyana ya Wufalansa",
        "GH": "Khana",
        "GI": "Jibulalita",
        "GL": "Gilinilandi",
        "GM": "Gambiya",
        "GN": "Gine",
        "GP": "Gwadelupe",
        "GQ": "Ginekweta",
        "GR": "Wugiliki",
        "GT": "Gwatemala",
        "GU": "Gwamu",
        "GW": "Ginebisawu",
        "HN": "Hondulasi",
        "HR": "Kolasiya",
        "HT": "Hayiti",
        "HU": "Hungaliya",
        "ID": "Indonesiya",
        "IE": "Ayalandi",
        "IL": "Isilaeli",
        "IN": "Indiya",
        "IO": "Uluvala lwa Uwingelesa ku Bahali ya Hindi",
        "IQ": "Ilaki",
        "IR": "Uwajemi",
        "IS": "Ayisilendi",
        "IT": "Italiya",
        "JM": "Jamaika",
        "JO": "Yolodani",
        "JP": "Japani",
        "KG": "Kiligisisitani",
        "KH": "Kambodiya",
        "KI": "Kilibati",
        "KM": "Komolo",
        "KN": "Santakitisi ni Nevisi",
        "KP": "Koleya ya luvala lwa Kunyamande",
        "KR": "Koleya ya Kusini",
        "KW": "Kuwaiti",
        "KY": "Figunguli ifya Kayimayi",
        "KZ": "Kasakisitani",
        "LA": "Layosi",
        "LB": "Lebanoni",
        "LC": "Santalusiya",
        "LI": "Lisheniteni",
        "LK": "Sililanka",
        "LR": "Libeliya",
        "LS": "Lesoto",
        "LT": "Litwaniya",
        "LU": "Lasembagi",
        "LV": "Lativiya",
        "LY": "Libiya",
        "MA": "Moloko",
        "MC": "Monako",
        "MD": "Molidova",
        "MG": "Bukini",
        "MH": "Figunguli ifya Malishali",
        "MK": "Masedoniya",
        "MM": "Muyama",
        "MN": "Mongoliya",
        "MP": "Figunguli fya Maliyana ifya luvala lwa Kunyamande",
        "MQ": "Malitiniki",
        "MR": "Molitaniya",
        "MS": "Monitiselati",
        "MT": "Malita",
        "MU": "Molisi",
        "MV": "Modivu",
        "MX": "Mekisiko",
        "MY": "Malesiya",
        "MZ": "Musumbiji",
        "NA": "Namibiya",
        "NC": "Nyukaledoniya",
        "NE": "Nijeli",
        "NF": "Shigunguli sha Nolifoki",
        "NG": "Nijeliya",
        "NI": "Nikalagwa",
        "NL": "Wuholansi",
        "NO": "Nolwe",
        "NP": "Nepali",
        "NR": "Nawulu",
        "NU": "Niwue",
        "NZ": "Nyusilendi",
        "OM": "Omani",
        "PE": "Pelu",
        "PF": "Polinesiya ya Wufalansa",
        "PG": "Papuwa",
        "PH": "Filipino",
        "PK": "Pakisitani",
        "PL": "Polandi",
        "PM": "Santapieli ni Mikeloni",
        "PN": "Pitikailini",
        "PR": "Pwetoliko",
        "PS": "Munjema gwa Kusikha nu Luvala lwa Gasa lwa Palesit",
        "PT": "Wuleno",
        "PW": "Palawu",
        "PY": "Palagwayi",
        "QA": "Katali",
        "RE": "Liyunioni",
        "RO": "Lomaniya",
        "RU": "Wulusi",
        "RW": "Lwanda",
        "SA": "Sawudi",
        "SB": "Figunguli fya Solomoni",
        "SC": "Shelisheli",
        "SD": "Sudani",
        "SE": "Uswidi",
        "SG": "Singapoo",
        "SH": "Santahelena",
        "SI": "Siloveniya",
        "SK": "Silovakiya",
        "SL": "Siela Liyoni",
        "SM": "Samalino",
        "SN": "Senegali",
        "SO": "Somaliya",
        "SR": "Sulinamu",
        "ST": "Sayo Tome ni Pilinikipe",
        "SV": "Elisavado",
        "SY": "Siliya",
        "SZ": "Uswasi",
        "TC": "Figunguli fya Tuliki ni Kaiko",
        "TD": "Shadi",
        "TH": "Tailandi",
        "TJ": "Tajikisitani",
        "TK": "Tokelawu",
        "TL": "Timoli ya kunena",
        "TM": "Tulukimenisitani",
        "TN": "Tunisiya",
        "TR": "Utuluki",
        "TT": "Tilinidadi ni Tobago",
        "TW": "Taiwani",
        "TZ": "Tansaniya",
        "UA": "Yukileini",
        "US": "Malekani",
        "UY": "Ulugwayi",
        "UZ": "Usibekisitani",
        "VA": "Vatikani",
        "VC": "Santavisenti na Gilenadini",
        "VE": "Venesuela",
        "VG": "Figunguli ifya Viliginiya ifya Uwingelesa",
        "VI": "Figunguli fya Viliginiya ifya Malekani",
        "VN": "Vietinamu",
        "WF": "Walisi ni Futuna",
        "WS": "Samoya",
        "YE": "Yemeni",
        "YT": "Mayote",
        "ZA": "Afilika Kusini",
        "ZM": "Sambiya",
        "ZW": "Simbabwe"
    };
  }-*/;
}
