/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sk" locale.
 */
public class LocalizedNamesImpl_sk extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "SK",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CK",
        "CW",
        "CY",
        "TD",
        "CZ",
        "ME",
        "CL",
        "CN",
        "DK",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EG",
        "EC",
        "ER",
        "EE",
        "ET",
        "EU",
        "FO",
        "FK",
        "FJ",
        "PH",
        "FI",
        "GF",
        "PF",
        "TF",
        "FR",
        "GA",
        "GM",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GE",
        "GP",
        "GU",
        "GT",
        "GY",
        "GG",
        "GN",
        "GW",
        "HT",
        "HM",
        "AN",
        "NL",
        "HN",
        "HK",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "ZA",
        "GS",
        "KR",
        "SS",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LV",
        "LU",
        "MO",
        "MK",
        "MG",
        "HU",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "YT",
        "UM",
        "MX",
        "FM",
        "MM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "DE",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "NC",
        "NZ",
        "OM",
        "AC",
        "CP",
        "IM",
        "PK",
        "PW",
        "PS",
        "PA",
        "VI",
        "PG",
        "PY",
        "PE",
        "PN",
        "CI",
        "PL",
        "PR",
        "PT",
        "AT",
        "RE",
        "GQ",
        "RO",
        "RU",
        "RW",
        "KN",
        "MF",
        "PM",
        "SV",
        "WS",
        "SM",
        "SA",
        "SN",
        "KP",
        "MP",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "AE",
        "GB",
        "US",
        "RS",
        "LK",
        "CF",
        "SD",
        "SR",
        "SZ",
        "SH",
        "LC",
        "BL",
        "ST",
        "VC",
        "SY",
        "SB",
        "ES",
        "SJ",
        "CH",
        "SE",
        "TJ",
        "TW",
        "IT",
        "TZ",
        "TH",
        "QO",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "CX",
        "VN",
        "TL",
        "WF",
        "ZM",
        "EH",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Svet");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Severná Amerika");
    namesMap.put("005", "Južná Amerika");
    namesMap.put("009", "Oceánia");
    namesMap.put("011", "Západná Afrika");
    namesMap.put("013", "Stredná Amerika");
    namesMap.put("014", "Východná Afrika");
    namesMap.put("015", "Severná Afrika");
    namesMap.put("017", "Stredná Afrika");
    namesMap.put("018", "južné územia Afriky");
    namesMap.put("019", "Americký kontinent");
    namesMap.put("021", "severné územia Ameriky");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "Východná Ázia");
    namesMap.put("034", "Južná Ázia");
    namesMap.put("035", "Juhovýchodná Ázia");
    namesMap.put("039", "Južná Európa");
    namesMap.put("053", "Australázia");
    namesMap.put("054", "Melanézia");
    namesMap.put("057", "Mikronézia – oblasť");
    namesMap.put("061", "Polynézia");
    namesMap.put("142", "Ázia");
    namesMap.put("143", "Stredná Ázia");
    namesMap.put("145", "Západná Ázia");
    namesMap.put("150", "Európa");
    namesMap.put("151", "Východná Európa");
    namesMap.put("154", "Severná Európa");
    namesMap.put("155", "Západná Európa");
    namesMap.put("419", "Latinská Amerika");
    namesMap.put("AC", "Ostrov Ascensión");
    namesMap.put("AE", "Spojené arabské emiráty");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua a Barbuda");
    namesMap.put("AL", "Albánsko");
    namesMap.put("AM", "Arménsko");
    namesMap.put("AN", "Holandské Antily");
    namesMap.put("AQ", "Antarktída");
    namesMap.put("AR", "Argentína");
    namesMap.put("AS", "Americká Samoa");
    namesMap.put("AT", "Rakúsko");
    namesMap.put("AU", "Austrália");
    namesMap.put("AX", "Alandské ostrovy");
    namesMap.put("AZ", "Azerbajdžan");
    namesMap.put("BA", "Bosna a Hercegovina");
    namesMap.put("BD", "Bangladéš");
    namesMap.put("BE", "Belgicko");
    namesMap.put("BG", "Bulharsko");
    namesMap.put("BH", "Bahrajn");
    namesMap.put("BL", "Svätý Bartolomej");
    namesMap.put("BM", "Bermudy");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BQ", "Karibské Holandsko");
    namesMap.put("BR", "Brazília");
    namesMap.put("BS", "Bahamy");
    namesMap.put("BT", "Bhután");
    namesMap.put("BV", "Bouvetov ostrov");
    namesMap.put("BY", "Bielorusko");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosové ostrovy");
    namesMap.put("CD", "Kongo - Kinshasa");
    namesMap.put("CF", "Stredoafrická republika");
    namesMap.put("CG", "Kongo - Brazzaville");
    namesMap.put("CH", "Švajčiarsko");
    namesMap.put("CI", "Pobrežie Slonoviny");
    namesMap.put("CK", "Cookove ostrovy");
    namesMap.put("CL", "Čile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Čína");
    namesMap.put("CO", "Kolumbia");
    namesMap.put("CP", "Ostrov Clipperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kapverdy");
    namesMap.put("CX", "Vianočný ostrov");
    namesMap.put("CZ", "Česká republika");
    namesMap.put("DE", "Nemecko");
    namesMap.put("DJ", "Džibutsko");
    namesMap.put("DK", "Dánsko");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikánska republika");
    namesMap.put("DZ", "Alžírsko");
    namesMap.put("EA", "Ceuta a Melilla");
    namesMap.put("EC", "Ekvádor");
    namesMap.put("EE", "Estónsko");
    namesMap.put("EH", "Západná Sahara");
    namesMap.put("ES", "Španielsko");
    namesMap.put("ET", "Etiópia");
    namesMap.put("EU", "Európska únia");
    namesMap.put("FI", "Fínsko");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandské ostrovy");
    namesMap.put("FM", "Mikronézia");
    namesMap.put("FO", "Faerské ostrovy");
    namesMap.put("FR", "Francúzsko");
    namesMap.put("GB", "Spojené kráľovstvo");
    namesMap.put("GE", "Gruzínsko");
    namesMap.put("GF", "Francúzska Guayana");
    namesMap.put("GI", "Gibraltár");
    namesMap.put("GL", "Grónsko");
    namesMap.put("GQ", "Rovníková Guinea");
    namesMap.put("GR", "Grécko");
    namesMap.put("GS", "Južná Georgia a Južné Sandwichove ostrovy");
    namesMap.put("GY", "Guayana");
    namesMap.put("HK", "Hongkong OAO Číny");
    namesMap.put("HM", "Heardov ostrov a McDonaldove ostrovy");
    namesMap.put("HR", "Chorvátsko");
    namesMap.put("HU", "Maďarsko");
    namesMap.put("IC", "Kanárske ostrovy");
    namesMap.put("ID", "Indonézia");
    namesMap.put("IE", "Írsko");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Ostrov Man");
    namesMap.put("IO", "Britské indickooceánske územie");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Taliansko");
    namesMap.put("JM", "Jamajka");
    namesMap.put("JO", "Jordánsko");
    namesMap.put("JP", "Japonsko");
    namesMap.put("KE", "Keňa");
    namesMap.put("KG", "Kirgizsko");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komory");
    namesMap.put("KN", "Saint Kitts a Nevis");
    namesMap.put("KP", "Severná Kórea");
    namesMap.put("KR", "Južná Kórea");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KY", "Kajmanie ostrovy");
    namesMap.put("KZ", "Kazachstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Svätá Lucia");
    namesMap.put("LI", "Lichtenštajnsko");
    namesMap.put("LK", "Srí Lanka");
    namesMap.put("LR", "Libéria");
    namesMap.put("LT", "Litva");
    namesMap.put("LU", "Luxembursko");
    namesMap.put("LV", "Lotyšsko");
    namesMap.put("LY", "Líbya");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavsko");
    namesMap.put("ME", "Čierna Hora");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallove ostrovy");
    namesMap.put("MK", "Macedónsko");
    namesMap.put("MM", "Mjanmarsko");
    namesMap.put("MN", "Mongolsko");
    namesMap.put("MO", "Macao OAO Číny");
    namesMap.put("MP", "Severné Mariány");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mauritánia");
    namesMap.put("MU", "Maurícius");
    namesMap.put("MV", "Maldivy");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malajzia");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Nová Kaledónia");
    namesMap.put("NF", "Norfolkov ostrov");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Holandsko");
    namesMap.put("NO", "Nórsko");
    namesMap.put("NP", "Nepál");
    namesMap.put("NZ", "Nový Zéland");
    namesMap.put("OM", "Omán");
    namesMap.put("PF", "Francúzska Polynézia");
    namesMap.put("PG", "Papua Nová Guinea");
    namesMap.put("PH", "Filipíny");
    namesMap.put("PL", "Poľsko");
    namesMap.put("PM", "Saint Pierre a Miquelon");
    namesMap.put("PN", "Pitcairnove ostrovy");
    namesMap.put("PR", "Portoriko");
    namesMap.put("PS", "Palestínske územie");
    namesMap.put("PT", "Portugalsko");
    namesMap.put("PY", "Paraguaj");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Tichomorie - ostatné");
    namesMap.put("RO", "Rumunsko");
    namesMap.put("RS", "Srbsko");
    namesMap.put("RU", "Rusko");
    namesMap.put("SA", "Saudská Arábia");
    namesMap.put("SB", "Šalamúnove ostrovy");
    namesMap.put("SC", "Seychelské ostrovy");
    namesMap.put("SD", "Sudán");
    namesMap.put("SE", "Švédsko");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Svätá Helena");
    namesMap.put("SI", "Slovinsko");
    namesMap.put("SJ", "Špicbergy a Jan Mayen");
    namesMap.put("SK", "Slovensko");
    namesMap.put("SM", "San Maríno");
    namesMap.put("SO", "Somálsko");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Južný Sudán");
    namesMap.put("ST", "Svätý Tomáš a Princove ostrovy");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Sýria");
    namesMap.put("SZ", "Svazijsko");
    namesMap.put("TC", "Turks a Caicos");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Francúzske južné a antarktické územia");
    namesMap.put("TH", "Thajsko");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TL", "Východný Timor");
    namesMap.put("TM", "Turkménsko");
    namesMap.put("TN", "Tunisko");
    namesMap.put("TR", "Turecko");
    namesMap.put("TT", "Trinidad a Tobago");
    namesMap.put("TZ", "Tanzánia");
    namesMap.put("UA", "Ukrajina");
    namesMap.put("UM", "Menšie odľahlé ostrovy USA");
    namesMap.put("US", "Spojené štáty");
    namesMap.put("UY", "Uruguaj");
    namesMap.put("VA", "Vatikán");
    namesMap.put("VC", "Svätý Vincent a Grenadíny");
    namesMap.put("VG", "Britské panenské ostrovy");
    namesMap.put("VI", "Panenské ostrovy - USA");
    namesMap.put("WF", "Wallis a Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Južná Afrika");
    namesMap.put("ZZ", "Neznámy región");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Svet",
        "002": "Afrika",
        "003": "Severná Amerika",
        "005": "Južná Amerika",
        "009": "Oceánia",
        "011": "Západná Afrika",
        "013": "Stredná Amerika",
        "014": "Východná Afrika",
        "015": "Severná Afrika",
        "017": "Stredná Afrika",
        "018": "južné územia Afriky",
        "019": "Americký kontinent",
        "021": "severné územia Ameriky",
        "029": "Karibik",
        "030": "Východná Ázia",
        "034": "Južná Ázia",
        "035": "Juhovýchodná Ázia",
        "039": "Južná Európa",
        "053": "Australázia",
        "054": "Melanézia",
        "057": "Mikronézia – oblasť",
        "061": "Polynézia",
        "142": "Ázia",
        "143": "Stredná Ázia",
        "145": "Západná Ázia",
        "150": "Európa",
        "151": "Východná Európa",
        "154": "Severná Európa",
        "155": "Západná Európa",
        "419": "Latinská Amerika",
        "AC": "Ostrov Ascensión",
        "AE": "Spojené arabské emiráty",
        "AF": "Afganistan",
        "AG": "Antigua a Barbuda",
        "AL": "Albánsko",
        "AM": "Arménsko",
        "AN": "Holandské Antily",
        "AQ": "Antarktída",
        "AR": "Argentína",
        "AS": "Americká Samoa",
        "AT": "Rakúsko",
        "AU": "Austrália",
        "AX": "Alandské ostrovy",
        "AZ": "Azerbajdžan",
        "BA": "Bosna a Hercegovina",
        "BD": "Bangladéš",
        "BE": "Belgicko",
        "BG": "Bulharsko",
        "BH": "Bahrajn",
        "BL": "Svätý Bartolomej",
        "BM": "Bermudy",
        "BN": "Brunej",
        "BO": "Bolívia",
        "BQ": "Karibské Holandsko",
        "BR": "Brazília",
        "BS": "Bahamy",
        "BT": "Bhután",
        "BV": "Bouvetov ostrov",
        "BY": "Bielorusko",
        "CA": "Kanada",
        "CC": "Kokosové ostrovy",
        "CD": "Kongo - Kinshasa",
        "CF": "Stredoafrická republika",
        "CG": "Kongo - Brazzaville",
        "CH": "Švajčiarsko",
        "CI": "Pobrežie Slonoviny",
        "CK": "Cookove ostrovy",
        "CL": "Čile",
        "CM": "Kamerun",
        "CN": "Čína",
        "CO": "Kolumbia",
        "CP": "Ostrov Clipperton",
        "CR": "Kostarika",
        "CU": "Kuba",
        "CV": "Kapverdy",
        "CX": "Vianočný ostrov",
        "CZ": "Česká republika",
        "DE": "Nemecko",
        "DJ": "Džibutsko",
        "DK": "Dánsko",
        "DM": "Dominika",
        "DO": "Dominikánska republika",
        "DZ": "Alžírsko",
        "EA": "Ceuta a Melilla",
        "EC": "Ekvádor",
        "EE": "Estónsko",
        "EH": "Západná Sahara",
        "ES": "Španielsko",
        "ET": "Etiópia",
        "EU": "Európska únia",
        "FI": "Fínsko",
        "FJ": "Fidži",
        "FK": "Falklandské ostrovy",
        "FM": "Mikronézia",
        "FO": "Faerské ostrovy",
        "FR": "Francúzsko",
        "GB": "Spojené kráľovstvo",
        "GE": "Gruzínsko",
        "GF": "Francúzska Guayana",
        "GI": "Gibraltár",
        "GL": "Grónsko",
        "GQ": "Rovníková Guinea",
        "GR": "Grécko",
        "GS": "Južná Georgia a Južné Sandwichove ostrovy",
        "GY": "Guayana",
        "HK": "Hongkong OAO Číny",
        "HM": "Heardov ostrov a McDonaldove ostrovy",
        "HR": "Chorvátsko",
        "HU": "Maďarsko",
        "IC": "Kanárske ostrovy",
        "ID": "Indonézia",
        "IE": "Írsko",
        "IL": "Izrael",
        "IM": "Ostrov Man",
        "IO": "Britské indickooceánske územie",
        "IQ": "Irak",
        "IR": "Irán",
        "IS": "Island",
        "IT": "Taliansko",
        "JM": "Jamajka",
        "JO": "Jordánsko",
        "JP": "Japonsko",
        "KE": "Keňa",
        "KG": "Kirgizsko",
        "KH": "Kambodža",
        "KM": "Komory",
        "KN": "Saint Kitts a Nevis",
        "KP": "Severná Kórea",
        "KR": "Južná Kórea",
        "KW": "Kuvajt",
        "KY": "Kajmanie ostrovy",
        "KZ": "Kazachstan",
        "LB": "Libanon",
        "LC": "Svätá Lucia",
        "LI": "Lichtenštajnsko",
        "LK": "Srí Lanka",
        "LR": "Libéria",
        "LT": "Litva",
        "LU": "Luxembursko",
        "LV": "Lotyšsko",
        "LY": "Líbya",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavsko",
        "ME": "Čierna Hora",
        "MG": "Madagaskar",
        "MH": "Marshallove ostrovy",
        "MK": "Macedónsko",
        "MM": "Mjanmarsko",
        "MN": "Mongolsko",
        "MO": "Macao OAO Číny",
        "MP": "Severné Mariány",
        "MQ": "Martinik",
        "MR": "Mauritánia",
        "MU": "Maurícius",
        "MV": "Maldivy",
        "MX": "Mexiko",
        "MY": "Malajzia",
        "MZ": "Mozambik",
        "NA": "Namíbia",
        "NC": "Nová Kaledónia",
        "NF": "Norfolkov ostrov",
        "NG": "Nigéria",
        "NI": "Nikaragua",
        "NL": "Holandsko",
        "NO": "Nórsko",
        "NP": "Nepál",
        "NZ": "Nový Zéland",
        "OM": "Omán",
        "PF": "Francúzska Polynézia",
        "PG": "Papua Nová Guinea",
        "PH": "Filipíny",
        "PL": "Poľsko",
        "PM": "Saint Pierre a Miquelon",
        "PN": "Pitcairnove ostrovy",
        "PR": "Portoriko",
        "PS": "Palestínske územie",
        "PT": "Portugalsko",
        "PY": "Paraguaj",
        "QA": "Katar",
        "QO": "Tichomorie - ostatné",
        "RO": "Rumunsko",
        "RS": "Srbsko",
        "RU": "Rusko",
        "SA": "Saudská Arábia",
        "SB": "Šalamúnove ostrovy",
        "SC": "Seychelské ostrovy",
        "SD": "Sudán",
        "SE": "Švédsko",
        "SG": "Singapur",
        "SH": "Svätá Helena",
        "SI": "Slovinsko",
        "SJ": "Špicbergy a Jan Mayen",
        "SK": "Slovensko",
        "SM": "San Maríno",
        "SO": "Somálsko",
        "SR": "Surinam",
        "SS": "Južný Sudán",
        "ST": "Svätý Tomáš a Princove ostrovy",
        "SV": "Salvador",
        "SY": "Sýria",
        "SZ": "Svazijsko",
        "TC": "Turks a Caicos",
        "TD": "Čad",
        "TF": "Francúzske južné a antarktické územia",
        "TH": "Thajsko",
        "TJ": "Tadžikistan",
        "TL": "Východný Timor",
        "TM": "Turkménsko",
        "TN": "Tunisko",
        "TR": "Turecko",
        "TT": "Trinidad a Tobago",
        "TZ": "Tanzánia",
        "UA": "Ukrajina",
        "UM": "Menšie odľahlé ostrovy USA",
        "US": "Spojené štáty",
        "UY": "Uruguaj",
        "VA": "Vatikán",
        "VC": "Svätý Vincent a Grenadíny",
        "VG": "Britské panenské ostrovy",
        "VI": "Panenské ostrovy - USA",
        "WF": "Wallis a Futuna",
        "YE": "Jemen",
        "ZA": "Južná Afrika",
        "ZZ": "Neznámy región"
    };
  }-*/;
}
