/*
 * Copyright 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.inject.client.binder;

import com.google.gwt.inject.client.GinModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;

public interface GinBinder {

  <T> GinAnnotatedBindingBuilder<T> bind(Class<T> clazz);

  <T> GinAnnotatedBindingBuilder<T> bind(TypeLiteral<T> type);

  <T> GinLinkedBindingBuilder<T> bind(Key<T> key);

  GinAnnotatedConstantBindingBuilder bindConstant();

  void install(GinModule install); // not using proper generics for compat with Guice 1.0

  void requestStaticInjection(Class<?>... types);
}
