/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GoogleCodingConvention;
import com.google.javascript.jscomp.LintPassConfig;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.refactoring.ApplySuggestedFixes;
import com.google.javascript.refactoring.FixingErrorManager;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

@GwtIncompatible(value="Unnecessary")
public final class Linter {
    static final int MAX_FIXES = 5;

    private Linter() {
    }

    static void lint(String filename) throws IOException {
        Linter.lint(Paths.get(filename, new String[0]), new Compiler(System.out));
    }

    static void lint(Path path, Compiler compiler) throws IOException {
        SourceFile file = SourceFile.fromFile(path.toString());
        CompilerOptions options = new CompilerOptions();
        options.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
        options.setPrettyPrint(true);
        options.setPreserveTypeAnnotations(true);
        options.setPreferSingleQuotes(true);
        options.setEmitUseStrict(false);
        options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_DESCRIPTIONS_WITH_WHITESPACE);
        options.setCodingConvention(new GoogleCodingConvention());
        options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.JSDOC_MISSING_TYPE, CheckLevel.ERROR);
        options.setWarningLevel(DiagnosticGroups.MISPLACED_MSG_ANNOTATION, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.UNNECESSARY_ESCAPE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.UNUSED_LOCAL_VARIABLE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.UNUSED_PRIVATE_PROPERTY, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.STRICT_MISSING_REQUIRE, CheckLevel.ERROR);
        options.setWarningLevel(DiagnosticGroups.EXTRA_REQUIRE, CheckLevel.ERROR);
        options.setWarningLevel(DiagnosticGroups.USE_OF_GOOG_BASE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.MISPLACED_SUPPRESS, CheckLevel.WARNING);
        options.setSummaryDetailLevel(0);
        compiler.setPassConfig(new LintPassConfig(options));
        compiler.disableThreads();
        SourceFile externs = SourceFile.fromCode("<Linter externs>", "");
        compiler.compile(ImmutableList.of((Object)externs), ImmutableList.of((Object)file), options);
    }

    static void fixRepeatedly(String filename) throws IOException {
        Linter.fixRepeatedly(filename, (ImmutableSet<DiagnosticType>)ImmutableSet.of());
    }

    static void fixRepeatedly(String filename, ImmutableSet<DiagnosticType> unfixableErrors) throws IOException {
        for (int i = 0; i < 5 && Linter.fix(filename, unfixableErrors); ++i) {
        }
    }

    private static boolean fix(String filename, ImmutableSet<DiagnosticType> unfixableErrors) throws IOException {
        Compiler compiler = new Compiler(System.out);
        FixingErrorManager errorManager = new FixingErrorManager(unfixableErrors);
        compiler.setErrorManager(errorManager);
        errorManager.setCompiler(compiler);
        Linter.lint(Paths.get(filename, new String[0]), compiler);
        Collection<SuggestedFix> fixes = errorManager.getAllFixes();
        if (!fixes.isEmpty()) {
            ApplySuggestedFixes.applySuggestedFixesToFiles(fixes);
            return true;
        }
        return false;
    }
}

