/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import java.io.Serializable;

public final class Reference
implements StaticRef,
Serializable {
    private static final ImmutableSet<Token> DECLARATION_PARENTS = ImmutableSet.of((Object)((Object)Token.VAR), (Object)((Object)Token.LET), (Object)((Object)Token.CONST), (Object)((Object)Token.PARAM_LIST), (Object)((Object)Token.FUNCTION), (Object)((Object)Token.CLASS), (Object[])new Token[]{Token.CATCH});
    private final Node nameNode;
    private final BasicBlock basicBlock;
    private final Scope scope;
    private final InputId inputId;

    Reference(Node nameNode, NodeTraversal t, BasicBlock basicBlock) {
        this(nameNode, basicBlock, t.getScope(), t.getInput().getInputId());
    }

    private Reference(Node nameNode, BasicBlock basicBlock, Scope scope, InputId inputId) {
        this.nameNode = nameNode;
        this.basicBlock = basicBlock;
        this.scope = scope;
        this.inputId = inputId;
    }

    public String toString() {
        return this.nameNode.toString();
    }

    @VisibleForTesting
    static Reference createRefForTest(CompilerInput input) {
        return new Reference(new Node(Token.NAME), null, null, input.getInputId());
    }

    Reference cloneWithNewScope(Scope newScope) {
        return new Reference(this.nameNode, this.basicBlock, newScope, this.inputId);
    }

    @Override
    public Var getSymbol() {
        return (Var)this.scope.getVar(this.nameNode.getString());
    }

    @Override
    public Node getNode() {
        return this.nameNode;
    }

    public InputId getInputId() {
        return this.inputId;
    }

    @Override
    public StaticSourceFile getSourceFile() {
        return this.nameNode.getStaticSourceFile();
    }

    boolean isDeclaration() {
        return Reference.isDeclarationHelper(this.nameNode);
    }

    private static boolean isDeclarationHelper(Node node) {
        Node parent = node.getParent();
        if (parent.isClass() && node != parent.getFirstChild()) {
            return false;
        }
        if (parent.getParent() == null) {
            return false;
        }
        if (NodeUtil.isNameDeclaration(parent.getParent()) && node == parent.getSecondChild()) {
            return false;
        }
        if (parent.isDestructuringLhs() || parent.isDestructuringPattern() || parent.isRest() || parent.isStringKey() && parent.getParent().isObjectPattern() || parent.isComputedProp() && parent.getParent().isObjectPattern() && node == parent.getLastChild() || parent.isDefaultValue() && node == parent.getFirstChild()) {
            return Reference.isDeclarationHelper(parent);
        }
        if (parent.isImport()) {
            return true;
        }
        if (parent.isImportSpec() && node == parent.getLastChild()) {
            return true;
        }
        if (parent.isArrowFunction()) {
            return node == parent.getFirstChild();
        }
        return DECLARATION_PARENTS.contains((Object)parent.getToken());
    }

    public boolean isVarDeclaration() {
        return this.getParent().isVar();
    }

    boolean isLetDeclaration() {
        return this.getParent().isLet();
    }

    public boolean isConstDeclaration() {
        return this.getParent().isConst();
    }

    boolean isHoistedFunction() {
        return NodeUtil.isHoistedFunctionDeclaration(this.getParent());
    }

    public boolean isInitializingDeclaration() {
        return this.isDeclaration() && !this.getParent().isVar() && !this.getParent().isLet() || this.nameNode.hasChildren();
    }

    Node getAssignedValue() {
        return NodeUtil.getRValueOfLValue(this.nameNode);
    }

    BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    Node getParent() {
        return this.getNode().getParent();
    }

    Node getGrandparent() {
        return this.getNode().getGrandparent();
    }

    private static boolean isLhsOfEnhancedForExpression(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isEnhancedFor(parent) && parent.getFirstChild() == n;
    }

    public boolean isSimpleAssignmentToName() {
        Node parent = this.getParent();
        return parent.isAssign() && parent.getFirstChild() == this.nameNode;
    }

    public boolean isLvalue() {
        Node parent = this.getParent();
        Token parentType = parent.getToken();
        switch (parentType) {
            case VAR: 
            case LET: 
            case CONST: {
                return this.nameNode.hasChildren() || Reference.isLhsOfEnhancedForExpression(this.nameNode);
            }
            case DEFAULT_VALUE: {
                return parent.getFirstChild() == this.nameNode;
            }
            case INC: 
            case DEC: 
            case CATCH: 
            case REST: 
            case PARAM_LIST: {
                return true;
            }
            case FOR: 
            case FOR_IN: 
            case FOR_OF: {
                return NodeUtil.isEnhancedFor(parent) && parent.getFirstChild() == this.nameNode;
            }
            case ARRAY_PATTERN: 
            case STRING_KEY: 
            case COMPUTED_PROP: {
                return NodeUtil.isLhsByDestructuring(this.nameNode);
            }
        }
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == this.nameNode;
    }

    Scope getScope() {
        return this.scope;
    }
}

