/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RewriteAsyncIteration
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_GENERATORS, FeatureSet.Feature.FOR_AWAIT_OF);
    static final DiagnosticType CANNOT_CONVERT_ASYNCGEN = DiagnosticType.error("JSC_CANNOT_CONVERT_ASYNCGEN", "Cannot convert async generator. {0}");
    private static final String GENERATOR_WRAPPER_NAME = "$jscomp.AsyncGeneratorWrapper";
    private static final String ACTION_RECORD_NAME = "$jscomp.AsyncGeneratorWrapper$ActionRecord";
    private static final String ACTION_ENUM_AWAIT = "$jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE";
    private static final String ACTION_ENUM_YIELD = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE";
    private static final String ACTION_ENUM_YIELD_STAR = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR";
    private static final String FOR_AWAIT_ITERATOR_TEMP_NAME = "$jscomp$forAwait$tempIterator";
    private static final String FOR_AWAIT_RESULT_TEMP_NAME = "$jscomp$forAwait$tempResult";
    private int nextForAwaitId = 0;
    private final AbstractCompiler compiler;
    private final ArrayDeque<LexicalContext> contextStack;
    private final String thisVarName = "$jscomp$asyncIter$this";
    private final String argumentsVarName = "$jscomp$asyncIter$arguments";
    private final String superPropGetterPrefix = "$jscomp$asyncIter$super$get$";

    RewriteAsyncIteration(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.contextStack = new ArrayDeque();
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.process(scriptRoot);
    }

    @Override
    public void process(Node externs, Node root) {
        this.process(root);
    }

    private void process(Node root) {
        Preconditions.checkState((boolean)this.contextStack.isEmpty());
        this.contextStack.push(LexicalContext.newGlobalContext());
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
        Preconditions.checkState((this.contextStack.element().function == null ? 1 : 0) != 0);
        this.contextStack.remove();
        Preconditions.checkState((boolean)this.contextStack.isEmpty());
    }

    private boolean isInContextOfAsyncGenerator(LexicalContext ctx) {
        return ctx.thisSuperArgsContext != null && ctx.getFunctionDeclaringThisArgsSuper().isAsyncGeneratorFunction();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.push(LexicalContext.newContextForFunction(this.contextStack.element(), n));
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext ctx = this.contextStack.element();
        switch (n.getToken()) {
            case FUNCTION: {
                Preconditions.checkState((boolean)n.equals(ctx.function));
                if (n.isAsyncGeneratorFunction()) {
                    this.convertAsyncGenerator(n);
                    this.prependTempVarDeclarations(ctx, t);
                }
                this.contextStack.pop();
                break;
            }
            case AWAIT: {
                Preconditions.checkNotNull((Object)ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertAwaitOfAsyncGenerator(ctx, n);
                break;
            }
            case YIELD: {
                Preconditions.checkNotNull((Object)ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertYieldOfAsyncGenerator(ctx, n);
                break;
            }
            case FOR_AWAIT_OF: {
                Preconditions.checkNotNull((Object)ctx.function);
                Preconditions.checkState((boolean)ctx.function.isAsyncFunction());
                this.replaceForAwaitOf(ctx, n);
                NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
                break;
            }
            case THIS: {
                if (!this.isInContextOfAsyncGenerator(ctx)) break;
                this.replaceThis(ctx, n);
                break;
            }
            case NAME: {
                if (!this.isInContextOfAsyncGenerator(ctx) || !n.matchesQualifiedName("arguments")) break;
                this.replaceArguments(ctx, n);
                break;
            }
            case SUPER: {
                if (!this.isInContextOfAsyncGenerator(ctx)) break;
                this.replaceSuper(ctx, n, parent);
                break;
            }
        }
    }

    private void convertAsyncGenerator(Node originalFunction) {
        Preconditions.checkNotNull((Object)originalFunction);
        Preconditions.checkState((boolean)originalFunction.isAsyncGeneratorFunction());
        Node innerBlock = originalFunction.getLastChild();
        originalFunction.removeChild(innerBlock);
        Node innerFunction = IR.function(IR.name(""), IR.paramList(), innerBlock);
        innerFunction.setIsGeneratorFunction(true);
        Node outerBlock = IR.block(IR.returnNode(IR.newNode(NodeUtil.newQName(this.compiler, GENERATOR_WRAPPER_NAME), NodeUtil.newCallNode(innerFunction, new Node[0]))));
        originalFunction.addChildToBack(outerBlock);
        originalFunction.setIsAsyncFunction(false);
        originalFunction.setIsGeneratorFunction(false);
        originalFunction.useSourceInfoIfMissingFromForTree(originalFunction);
        this.compiler.reportChangeToChangeScope(originalFunction);
        this.compiler.reportChangeToChangeScope(innerFunction);
    }

    private void convertAwaitOfAsyncGenerator(LexicalContext ctx, Node awaitNode) {
        Preconditions.checkNotNull((Object)awaitNode);
        Preconditions.checkState((boolean)awaitNode.isAwait());
        Preconditions.checkState((ctx != null && ctx.function != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)ctx.function.isAsyncGeneratorFunction());
        Node expression = awaitNode.removeFirstChild();
        Preconditions.checkNotNull((Object)expression, (Object)"await needs an expression");
        Node newActionRecord = IR.newNode(NodeUtil.newQName(this.compiler, ACTION_RECORD_NAME), NodeUtil.newQName(this.compiler, ACTION_ENUM_AWAIT), expression);
        newActionRecord.useSourceInfoIfMissingFromForTree(awaitNode);
        awaitNode.addChildToFront(newActionRecord);
        awaitNode.setToken(Token.YIELD);
    }

    private void convertYieldOfAsyncGenerator(LexicalContext ctx, Node yieldNode) {
        Preconditions.checkNotNull((Object)yieldNode);
        Preconditions.checkState((boolean)yieldNode.isYield());
        Preconditions.checkState((ctx != null && ctx.function != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)ctx.function.isAsyncGeneratorFunction());
        Node expression = yieldNode.removeFirstChild();
        Node newActionRecord = IR.newNode(NodeUtil.newQName(this.compiler, ACTION_RECORD_NAME), new Node[0]);
        if (yieldNode.isYieldAll()) {
            Preconditions.checkNotNull((Object)expression);
            newActionRecord.addChildToBack(NodeUtil.newQName(this.compiler, ACTION_ENUM_YIELD_STAR));
            newActionRecord.addChildToBack(expression);
        } else {
            if (expression == null) {
                expression = NodeUtil.newUndefinedNode(null);
            }
            newActionRecord.addChildToBack(NodeUtil.newQName(this.compiler, ACTION_ENUM_YIELD));
            newActionRecord.addChildToBack(expression);
        }
        newActionRecord.useSourceInfoIfMissingFromForTree(yieldNode);
        yieldNode.addChildToFront(newActionRecord);
        yieldNode.removeProp((byte)62);
    }

    private void replaceForAwaitOf(LexicalContext ctx, Node forAwaitOf) {
        Node lhsAssignment;
        int forAwaitId = this.nextForAwaitId++;
        String iteratorTempName = FOR_AWAIT_ITERATOR_TEMP_NAME + forAwaitId;
        String resultTempName = FOR_AWAIT_RESULT_TEMP_NAME + forAwaitId;
        Preconditions.checkState((forAwaitOf.getParent() != null ? 1 : 0) != 0, (Object)"Cannot replace parentless for-await-of");
        Node lhs = forAwaitOf.removeFirstChild();
        Node rhs = forAwaitOf.removeFirstChild();
        Node originalBody = forAwaitOf.removeFirstChild();
        Node initializer = IR.constNode(IR.name(iteratorTempName), NodeUtil.newCallNode(NodeUtil.newQName(this.compiler, "$jscomp.makeAsyncIterator"), rhs)).useSourceInfoIfMissingFromForTree(rhs);
        Node resultDeclaration = IR.constNode(IR.name(resultTempName), this.constructAwaitNextResult(ctx, iteratorTempName));
        Node breakIfDone = IR.ifNode(IR.getprop(IR.name(resultTempName), "done", new String[0]), IR.block(IR.breakNode()));
        if (lhs.isValidAssignmentTarget()) {
            lhsAssignment = IR.exprResult(IR.assign(lhs, IR.getprop(IR.name(resultTempName), "value", new String[0])));
        } else if (NodeUtil.isNameDeclaration(lhs)) {
            lhs.getFirstChild().addChildToBack(IR.getprop(IR.name(resultTempName), "value", new String[0]));
            lhsAssignment = lhs;
        } else {
            throw new AssertionError((Object)"unexpected for-await-of lhs");
        }
        lhsAssignment.useSourceInfoIfMissingFromForTree(lhs);
        Node newForLoop = IR.forNode(initializer, IR.empty(), IR.empty(), IR.block(resultDeclaration, breakIfDone, lhsAssignment, this.ensureBlock(originalBody)));
        forAwaitOf.replaceWith(newForLoop);
        newForLoop.useSourceInfoIfMissingFromForTree(forAwaitOf);
        this.compiler.reportChangeToEnclosingScope(newForLoop);
    }

    private Node ensureBlock(Node possiblyBlock) {
        return possiblyBlock.isBlock() ? possiblyBlock : IR.block(possiblyBlock).useSourceInfoFrom(possiblyBlock);
    }

    private Node constructAwaitNextResult(LexicalContext ctx, String iteratorTempName) {
        Preconditions.checkNotNull((Object)ctx.function);
        if (!ctx.function.isAsyncGeneratorFunction()) {
            return IR.await(NodeUtil.newCallNode(IR.getprop(IR.name(iteratorTempName), "next", new String[0]), new Node[0]));
        }
        return IR.yield(IR.newNode(NodeUtil.newQName(this.compiler, ACTION_RECORD_NAME), NodeUtil.newQName(this.compiler, ACTION_ENUM_AWAIT), NodeUtil.newCallNode(IR.getprop(IR.name(iteratorTempName), "next", new String[0]), new Node[0])));
    }

    private void replaceThis(LexicalContext ctx, Node n) {
        Preconditions.checkArgument((boolean)n.isThis());
        Preconditions.checkArgument((ctx != null && this.isInContextOfAsyncGenerator(ctx) ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        n.replaceWith(IR.name("$jscomp$asyncIter$this").useSourceInfoFrom(n));
        ctx.thisSuperArgsContext.usedThis = true;
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceArguments(LexicalContext ctx, Node n) {
        Preconditions.checkArgument((n.isName() && "arguments".equals(n.getString()) ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx != null && this.isInContextOfAsyncGenerator(ctx) ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        n.replaceWith(IR.name("$jscomp$asyncIter$arguments").useSourceInfoFrom(n));
        ctx.thisSuperArgsContext.usedArguments = true;
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceSuper(LexicalContext ctx, Node n, Node parent) {
        if (!parent.isGetProp()) {
            this.compiler.report(JSError.make(parent, CANNOT_CONVERT_ASYNCGEN, "super only allowed with getprop (like super.foo(), not super['foo']())"));
        }
        Preconditions.checkArgument((boolean)n.isSuper());
        Preconditions.checkArgument((ctx != null && this.isInContextOfAsyncGenerator(ctx) ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        Node propertyName = n.getNext();
        String propertyReplacementNameText = "$jscomp$asyncIter$super$get$" + propertyName.getString();
        Node getPropReplacement = NodeUtil.newCallNode(IR.name(propertyReplacementNameText), new Node[0]);
        Node grandparent = parent.getParent();
        if (grandparent.isCall() && grandparent.getFirstChild() == parent) {
            getPropReplacement = IR.getprop(getPropReplacement, IR.string("call"));
            grandparent.addChildAfter(IR.name("$jscomp$asyncIter$this").useSourceInfoFrom(parent), parent);
            ctx.thisSuperArgsContext.usedThis = true;
        }
        getPropReplacement.useSourceInfoFromForTree(parent);
        grandparent.replaceChild(parent, getPropReplacement);
        ctx.thisSuperArgsContext.usedSuperProperties.add(propertyName.getString());
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void prependTempVarDeclarations(LexicalContext ctx, NodeTraversal t) {
        Preconditions.checkArgument((ctx != null ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        ThisSuperArgsContext thisSuperArgsCtx = ctx.thisSuperArgsContext;
        Node function = ctx.function;
        Node block = function.getLastChild();
        Preconditions.checkNotNull((Object)block, (Object)function);
        Node prefixBlock = IR.block();
        if (thisSuperArgsCtx.usedThis) {
            prefixBlock.addChildToBack(IR.constNode(IR.name("$jscomp$asyncIter$this"), IR.thisNode()).useSourceInfoFromForTree(block));
        }
        if (thisSuperArgsCtx.usedArguments) {
            prefixBlock.addChildToBack(IR.constNode(IR.name("$jscomp$asyncIter$arguments"), IR.name("arguments")).useSourceInfoFromForTree(block));
        }
        for (String replacedMethodName : thisSuperArgsCtx.usedSuperProperties) {
            Node arrowFunction = IR.arrowFunction(IR.name(""), IR.paramList(), IR.getprop(IR.superNode(), IR.string(replacedMethodName)));
            this.compiler.reportChangeToChangeScope(arrowFunction);
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.ARROW_FUNCTIONS);
            String superReplacementName = "$jscomp$asyncIter$super$get$" + replacedMethodName;
            prefixBlock.addChildToBack(IR.constNode(IR.name(superReplacementName), arrowFunction));
        }
        prefixBlock.useSourceInfoIfMissingFromForTree(block);
        block.addChildrenToFront(prefixBlock.removeChildren());
        if (thisSuperArgsCtx.usedThis || thisSuperArgsCtx.usedArguments || !thisSuperArgsCtx.usedSuperProperties.isEmpty()) {
            this.compiler.reportChangeToChangeScope(function);
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
    }

    private static final class ThisSuperArgsContext {
        private final LexicalContext ctx;
        private final Set<String> usedSuperProperties = new LinkedHashSet<String>();
        private boolean usedThis = false;
        private boolean usedArguments = false;

        ThisSuperArgsContext(LexicalContext ctx) {
            this.ctx = ctx;
        }
    }

    private static final class LexicalContext {
        private final Node function;
        private final ThisSuperArgsContext thisSuperArgsContext;

        private LexicalContext() {
            this.function = null;
            this.thisSuperArgsContext = null;
        }

        private LexicalContext(LexicalContext parent, Node function) {
            Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)function);
            Preconditions.checkArgument((boolean)function.isFunction());
            this.function = function;
            this.thisSuperArgsContext = function.isArrowFunction() ? parent.thisSuperArgsContext : new ThisSuperArgsContext(this);
        }

        static LexicalContext newGlobalContext() {
            return new LexicalContext();
        }

        static LexicalContext newContextForFunction(LexicalContext parent, Node function) {
            return new LexicalContext(parent, function);
        }

        Node getFunctionDeclaringThisArgsSuper() {
            return ((ThisSuperArgsContext)this.thisSuperArgsContext).ctx.function;
        }
    }
}

