/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final String sourceFile;
    private final boolean checkAnnotated;

    public SourceInformationAnnotator(String sourceFile, boolean checkAnnotated) {
        this.sourceFile = sourceFile;
        this.checkAnnotated = checkAnnotated;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.checkAnnotated && this.sourceFile != null) {
            Preconditions.checkState((boolean)this.sourceFile.equals(n.getSourceFileName()));
        }
        switch (n.getToken()) {
            case GETPROP: {
                Node propNode = n.getLastChild();
                SourceInformationAnnotator.setOriginalName(n, propNode.getString());
                break;
            }
            case FUNCTION: {
                String functionName = NodeUtil.getNearestFunctionName(n);
                if (functionName == null) break;
                SourceInformationAnnotator.setOriginalName(n, functionName);
                break;
            }
            case NAME: {
                SourceInformationAnnotator.setOriginalName(n, n.getString());
                break;
            }
            case OBJECTLIT: {
                for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                    if (key.isComputedProp() || key.isQuotedString() || key.isSpread()) continue;
                    SourceInformationAnnotator.setOriginalName(key, key.getString());
                }
                break;
            }
        }
    }

    static void setOriginalName(Node n, String name) {
        if (!name.isEmpty() && n.getOriginalName() == null) {
            n.setOriginalName(name);
        }
    }
}

