/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.graph.DiGraph;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class FixedPointGraphTraversal<N, E> {
    private final EdgeCallback<N, E> callback;
    public static final String NON_HALTING_ERROR_MSG = "Fixed point computation not halting";

    public FixedPointGraphTraversal(EdgeCallback<N, E> callback) {
        this.callback = callback;
    }

    public static <NODE, EDGE> FixedPointGraphTraversal<NODE, EDGE> newTraversal(EdgeCallback<NODE, EDGE> callback) {
        return new FixedPointGraphTraversal<NODE, EDGE>(callback);
    }

    public void computeFixedPoint(DiGraph<N, E> graph) {
        LinkedHashSet nodes = new LinkedHashSet();
        for (DiGraph.DiGraphNode<N, E> node : graph.getDirectedGraphNodes()) {
            nodes.add(node.getValue());
        }
        this.computeFixedPoint(graph, nodes);
    }

    public void computeFixedPoint(DiGraph<N, E> graph, N entry) {
        LinkedHashSet<N> entrySet = new LinkedHashSet<N>();
        entrySet.add(entry);
        this.computeFixedPoint(graph, (Set<N>)entrySet);
    }

    public void computeFixedPoint(DiGraph<N, E> graph, Set<N> entrySet) {
        int cycleCount = 0;
        long nodeCount = graph.getNodeCount();
        long maxIterations = Math.max(nodeCount * nodeCount * nodeCount, 100L);
        LinkedHashSet workSet = new LinkedHashSet();
        for (N n : entrySet) {
            workSet.add(graph.getDirectedGraphNode(n));
        }
        while (!workSet.isEmpty() && (long)cycleCount < maxIterations) {
            DiGraph.DiGraphNode source = (DiGraph.DiGraphNode)workSet.iterator().next();
            Object sourceValue = source.getValue();
            workSet.remove(source);
            List outEdges = source.getOutEdges();
            for (DiGraph.DiGraphEdge edge : outEdges) {
                Object destNode = edge.getDestination().getValue();
                if (!this.callback.traverseEdge(sourceValue, edge.getValue(), destNode)) continue;
                workSet.add(edge.getDestination());
            }
            ++cycleCount;
        }
        Preconditions.checkState(((long)cycleCount != maxIterations ? 1 : 0) != 0, (Object)NON_HALTING_ERROR_MSG);
    }

    public static interface EdgeCallback<Node, Edge> {
        public boolean traverseEdge(Node var1, Edge var2, Node var3);
    }
}

