/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

public final class CheckEs6Modules
implements NodeTraversal.Callback,
CompilerPass {
    public static final DiagnosticType DUPLICATE_IMPORT = DiagnosticType.warning("JSC_DUPLICATE_IMPORT", "The module \"{0}\" has already been imported at {1}, {2}.");
    public static final DiagnosticType NO_DEFAULT_EXPORT = DiagnosticType.warning("JSC_DEFAULT_EXPORT", "Do not use the default export. There is no way to force consistent naming when imported.");
    private final AbstractCompiler compiler;
    private final Map<String, Node> importSpecifiers = new HashMap<String, Node>();

    public CheckEs6Modules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isModuleBody()) {
            this.importSpecifiers.clear();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case ROOT: 
            case MODULE_BODY: {
                return true;
            }
            case SCRIPT: {
                return n.getBooleanProp((byte)99);
            }
            case IMPORT: {
                this.visitImport(t, n);
                return false;
            }
            case EXPORT: {
                this.visitExport(t, n);
                return false;
            }
        }
        return false;
    }

    private void visitImport(NodeTraversal t, Node importNode) {
        String specifier = importNode.getLastChild().getString();
        Node duplicateImport = this.importSpecifiers.putIfAbsent(specifier, importNode);
        if (duplicateImport != null) {
            t.report(importNode, DUPLICATE_IMPORT, specifier, "" + duplicateImport.getLineno(), "" + duplicateImport.getCharno());
        }
    }

    private void visitExport(NodeTraversal t, Node export) {
        if (export.getBooleanProp((byte)63)) {
            t.report(export, NO_DEFAULT_EXPORT, new String[0]);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }
}

