/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.resources;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

public class GwtProperties {
    private final Map<String, String> contents;

    private GwtProperties(Map<String, String> contents) {
        this.contents = contents;
    }

    public String getProperty(String key) {
        return this.contents.get(key);
    }

    public Collection<String> propertyNames() {
        return this.contents.keySet();
    }

    private static String trimLeft(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            return str.substring(i);
        }
        return str;
    }

    private static int findDelimiter(String line) {
        if (line.contains(":") || line.contains("=")) {
            if (line.indexOf(58) == -1) {
                return line.indexOf(61);
            }
            if (line.indexOf(61) == -1) {
                return line.indexOf(58);
            }
            return Math.min(line.indexOf(61), line.indexOf(58));
        }
        return line.indexOf(32);
    }

    public static GwtProperties load(String source) {
        String[] lines = source.split("\r?\n");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < lines.length; ++i) {
            String key;
            String data;
            block3: {
                String line = lines[i];
                if (line.isEmpty() || line.startsWith("#") || line.startsWith("!")) continue;
                data = "";
                int delimeterIndex = GwtProperties.findDelimiter(line);
                if (delimeterIndex == -1) continue;
                key = line.substring(0, delimeterIndex).trim();
                line = GwtProperties.trimLeft(line.substring(delimeterIndex + 1));
                while (line.endsWith("\\")) {
                    data = data + line.substring(0, line.length() - 1);
                    if (i + 1 != lines.length) {
                        line = GwtProperties.trimLeft(lines[++i]);
                        continue;
                    }
                    break block3;
                }
                data = data + line;
            }
            builder.put((Object)key, (Object)data);
        }
        return new GwtProperties((Map<String, String>)builder.build());
    }
}

