/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class WhitelistWarningsGuard
extends WarningsGuard {
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n");
    private final Set<String> whitelist;
    private static final Pattern LINE_NUMBER = Pattern.compile(":-?\\d+");

    public WhitelistWarningsGuard(Set<String> whitelist) {
        Preconditions.checkNotNull(whitelist);
        this.whitelist = WhitelistWarningsGuard.normalizeWhitelist(whitelist);
    }

    private static Set<String> normalizeWhitelist(Set<String> whitelist) {
        HashSet result = Sets.newHashSet();
        for (String line : whitelist) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.charAt(0) == '#') continue;
            result.add(LINE_NUMBER.matcher(trimmed).replaceFirst(":"));
        }
        return ImmutableSet.copyOf((Collection)result);
    }

    @Override
    public CheckLevel level(JSError error) {
        if (this.containWarning(WhitelistWarningsGuard.formatWarning(error))) {
            return CheckLevel.WARNING;
        }
        return null;
    }

    protected boolean containWarning(String formattedWarning) {
        return this.whitelist.contains(formattedWarning);
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_WHITELIST.getValue();
    }

    public static WhitelistWarningsGuard fromFile(File file) {
        return new WhitelistWarningsGuard(WhitelistWarningsGuard.loadWhitelistedJsWarnings(file));
    }

    public static Set<String> loadWhitelistedJsWarnings(File file) {
        return WhitelistWarningsGuard.loadWhitelistedJsWarnings(Files.asCharSource((File)file, (Charset)Charsets.UTF_8));
    }

    protected static Set<String> loadWhitelistedJsWarnings(CharSource supplier) {
        try {
            return WhitelistWarningsGuard.loadWhitelistedJsWarnings(supplier.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<String> loadWhitelistedJsWarnings(Reader reader) throws IOException {
        Preconditions.checkNotNull((Object)reader);
        HashSet result = Sets.newHashSet();
        for (String line : CharStreams.readLines((Readable)reader)) {
            result.add(line);
        }
        return result;
    }

    public static String formatWarning(JSError error) {
        return WhitelistWarningsGuard.formatWarning(error, false);
    }

    public static String formatWarning(JSError error, boolean withMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append(error.sourceName).append(":");
        if (withMetaData) {
            sb.append(error.lineNumber);
        }
        ImmutableList lines = ImmutableList.copyOf((Iterable)LINE_SPLITTER.split((CharSequence)error.description));
        sb.append("  ").append((String)lines.get(0));
        if (withMetaData) {
            for (int i = 1; i < lines.size(); ++i) {
                sb.append("\n# ").append((String)lines.get(i));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getFirstLine(String warning) {
        int lineLength = warning.indexOf(10);
        if (lineLength > 0) {
            warning = warning.substring(0, lineLength);
        }
        return warning;
    }

    public static class WhitelistBuilder
    implements ErrorHandler {
        private final Set<JSError> warnings = Sets.newLinkedHashSet();
        private String productName = null;
        private String generatorTarget = null;
        private String headerNote = null;

        public WhitelistBuilder setProductName(String name) {
            this.productName = name;
            return this;
        }

        public WhitelistBuilder setGeneratorTarget(String name) {
            this.generatorTarget = name;
            return this;
        }

        public WhitelistBuilder setNote(String note) {
            this.headerNote = note;
            return this;
        }

        @Deprecated
        public WhitelistBuilder setWithLineNumber(boolean line) {
            return this;
        }

        @Override
        public void report(CheckLevel level, JSError error) {
            this.warnings.add(error);
        }

        public void writeWhitelist(File out) throws IOException {
            PrintStream stream = new PrintStream(out);
            this.appendWhitelist(stream);
            stream.close();
        }

        public void appendWhitelist(PrintStream out) {
            out.append("# This is a list of legacy warnings that have yet to be fixed.\n");
            if (this.productName != null && !this.productName.isEmpty()) {
                out.append("# Please find some time and fix at least one of them and it will be the happiest day for " + this.productName + ".\n");
            }
            if (this.generatorTarget != null && !this.generatorTarget.isEmpty()) {
                out.append("# When you fix any of these warnings, run " + this.generatorTarget + " task.\n");
            }
            if (this.headerNote != null) {
                out.append("#" + Joiner.on((String)"\n# ").join(Splitter.on((String)"\n").split((CharSequence)this.headerNote)) + "\n");
            }
            TreeMultimap warningsByType = TreeMultimap.create();
            for (JSError warning : this.warnings) {
                warningsByType.put((Object)warning.getType(), (Object)WhitelistWarningsGuard.formatWarning(warning, true));
            }
            for (DiagnosticType type : warningsByType.keySet()) {
                out.append("\n# Warning ").append(type.key).append(": ").println((String)Iterables.get((Iterable)LINE_SPLITTER.split((CharSequence)type.format.toPattern()), (int)0));
                for (String warning : warningsByType.get((Object)type)) {
                    out.println(warning);
                }
            }
            out.flush();
        }
    }
}

