package com.google.javascript.jscomp.serialization;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.rhino.Node;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;
import org.jspecify.annotations.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TypedAstDeserializer_DeserializedAst extends TypedAstDeserializer.DeserializedAst {

  private final ConcurrentMap<SourceFile, Supplier<Node>> filesystem;

  private final Optional<ColorRegistry> colorRegistry;

  private final @Nullable ImmutableSet<String> externProperties;

  private final ImmutableSet<String> runtimeLibraries;

  AutoValue_TypedAstDeserializer_DeserializedAst(
      ConcurrentMap<SourceFile, Supplier<Node>> filesystem,
      Optional<ColorRegistry> colorRegistry,
      @Nullable ImmutableSet<String> externProperties,
      ImmutableSet<String> runtimeLibraries) {
    if (filesystem == null) {
      throw new NullPointerException("Null filesystem");
    }
    this.filesystem = filesystem;
    if (colorRegistry == null) {
      throw new NullPointerException("Null colorRegistry");
    }
    this.colorRegistry = colorRegistry;
    this.externProperties = externProperties;
    if (runtimeLibraries == null) {
      throw new NullPointerException("Null runtimeLibraries");
    }
    this.runtimeLibraries = runtimeLibraries;
  }

  @Override
  public ConcurrentMap<SourceFile, Supplier<Node>> getFilesystem() {
    return filesystem;
  }

  @Override
  public Optional<ColorRegistry> getColorRegistry() {
    return colorRegistry;
  }

  @Override
  public @Nullable ImmutableSet<String> getExternProperties() {
    return externProperties;
  }

  @Override
  public ImmutableSet<String> getRuntimeLibraries() {
    return runtimeLibraries;
  }

  @Override
  public String toString() {
    return "DeserializedAst{"
        + "filesystem=" + filesystem + ", "
        + "colorRegistry=" + colorRegistry + ", "
        + "externProperties=" + externProperties + ", "
        + "runtimeLibraries=" + runtimeLibraries
        + "}";
  }

  @Override
  public boolean equals(@Nullable Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TypedAstDeserializer.DeserializedAst) {
      TypedAstDeserializer.DeserializedAst that = (TypedAstDeserializer.DeserializedAst) o;
      return this.filesystem.equals(that.getFilesystem())
          && this.colorRegistry.equals(that.getColorRegistry())
          && (this.externProperties == null ? that.getExternProperties() == null : this.externProperties.equals(that.getExternProperties()))
          && this.runtimeLibraries.equals(that.getRuntimeLibraries());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= filesystem.hashCode();
    h$ *= 1000003;
    h$ ^= colorRegistry.hashCode();
    h$ *= 1000003;
    h$ ^= (externProperties == null) ? 0 : externProperties.hashCode();
    h$ *= 1000003;
    h$ ^= runtimeLibraries.hashCode();
    return h$;
  }

}
