/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode;

import com.googlecode.ConsoleDownloadMonitor;
import com.googlecode.DownloadCache;
import com.googlecode.SignatureUtils;
import java.io.File;
import java.net.URL;
import java.security.MessageDigest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class WGet
extends AbstractMojo {
    private String url;
    private boolean overwrite;
    private String outputFileName;
    private File outputDirectory;
    private String md5;
    private String sha1;
    private boolean unpack;
    private int retries;
    private int readTimeOut;
    private boolean skipCache;
    private File cacheDirectory;
    private boolean skip;
    private MavenSession session;
    private ArchiverManager archiverManager;
    private WagonManager wagonManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped");
            return;
        }
        if (this.retries < 1) {
            throw new MojoFailureException("retries must be at least 1");
        }
        if (this.outputFileName == null) {
            try {
                this.outputFileName = new File(new URL(this.url).getFile()).getName();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Invalid URL", ex);
            }
        }
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(this.session.getLocalRepository().getBasedir(), ".cache/maven-download-plugin");
        }
        this.getLog().debug((CharSequence)("Cache is: " + this.cacheDirectory.getAbsolutePath()));
        DownloadCache cache = new DownloadCache(this.cacheDirectory);
        this.outputDirectory.mkdirs();
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        try {
            if (outputFile.exists() && !this.overwrite) {
                this.getLog().info((CharSequence)"File already exist, skipping");
            } else {
                File cached = cache.getArtifact(this.url, this.md5, this.sha1);
                if (!this.skipCache && cached != null && cached.exists()) {
                    this.getLog().info((CharSequence)("Got from cache: " + cached.getAbsolutePath()));
                    FileUtils.copyFile((File)cached, (File)outputFile);
                } else {
                    boolean done = false;
                    while (!done && this.retries > 0) {
                        try {
                            this.doGet(outputFile);
                            if (this.md5 != null) {
                                SignatureUtils.verifySignature(outputFile, this.md5, MessageDigest.getInstance("MD5"));
                            }
                            if (this.sha1 != null) {
                                SignatureUtils.verifySignature(outputFile, this.sha1, MessageDigest.getInstance("SHA1"));
                            }
                            done = true;
                        }
                        catch (Exception ex) {
                            this.getLog().warn((CharSequence)"Could not get content", (Throwable)ex);
                            --this.retries;
                            if (this.retries <= 0) continue;
                            this.getLog().warn((CharSequence)("Retrying (" + this.retries + " more)"));
                        }
                    }
                    if (!done) {
                        throw new MojoFailureException("Could not get content");
                    }
                }
            }
            cache.install(this.url, outputFile, this.md5, this.sha1);
            if (this.unpack) {
                this.unpack(outputFile);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("IO Error", ex);
        }
    }

    private void unpack(File outputFile) throws NoSuchArchiverException {
        UnArchiver unarchiver = this.archiverManager.getUnArchiver(outputFile);
        unarchiver.setSourceFile(outputFile);
        unarchiver.setDestDirectory(this.outputDirectory);
        unarchiver.extract();
        outputFile.delete();
    }

    private void doGet(File outputFile) throws Exception {
        String[] segments = this.url.split("/");
        String file = segments[segments.length - 1];
        String repoUrl = this.url.substring(0, this.url.length() - file.length() - 1);
        Repository repository = new Repository(repoUrl, repoUrl);
        Wagon wagon = this.wagonManager.getWagon(repository.getProtocol());
        if (this.readTimeOut > 0) {
            wagon.setReadTimeout(this.readTimeOut);
            this.getLog().info((CharSequence)("Read Timeout is set to " + this.readTimeOut + " milliseconds (apprx " + Math.round((double)this.readTimeOut * 1.66667E-5) + " minutes)"));
        }
        ConsoleDownloadMonitor downloadMonitor = new ConsoleDownloadMonitor();
        wagon.addTransferListener((TransferListener)downloadMonitor);
        wagon.connect(repository, this.wagonManager.getProxy(repository.getProtocol()));
        wagon.get(file, outputFile);
        wagon.disconnect();
        wagon.removeTransferListener((TransferListener)downloadMonitor);
    }
}

