/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositionTimeToSample
extends AbstractFullBox {
    public static final String TYPE = "ctts";
    List<Entry> entries = Collections.emptyList();

    public CompositionTimeToSample() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        return 4 + 8 * this.entries.size();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long numberOfEntries = in.readUInt32();
        assert (numberOfEntries <= Integer.MAX_VALUE) : "Too many entries";
        this.entries = new ArrayList<Entry>((int)numberOfEntries);
        int i = 0;
        while ((long)i < numberOfEntries) {
            Entry e = new Entry(in.readUInt32(), in.readInt32());
            this.entries.add(e);
            ++i;
        }
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            os.writeUInt32(entry.getCount());
            os.writeInt32(entry.getOffset());
        }
    }

    public static int[] blowupCompositionTimes(List<Entry> entries) {
        long numOfSamples = 0L;
        for (Entry entry : entries) {
            numOfSamples += entry.getCount();
        }
        assert (numOfSamples <= Integer.MAX_VALUE);
        int[] decodingTime = new int[(int)numOfSamples];
        int current = 0;
        for (Entry entry : entries) {
            int i = 0;
            while ((long)i < entry.getCount()) {
                decodingTime[current++] = entry.getOffset();
                ++i;
            }
        }
        return decodingTime;
    }

    public static class Entry {
        long count;
        int offset;

        public Entry(long count, int offset) {
            this.count = count;
            this.offset = offset;
        }

        public long getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String toString() {
            return "Entry{count=" + this.count + ", offset=" + this.offset + '}';
        }
    }
}

