/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class SampleSizeBox
extends AbstractFullBox {
    private long sampleSize;
    private long[] sampleSizes;
    public static final String TYPE = "stsz";
    long sampleCount;

    public SampleSizeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(long sampleSize) {
        this.sampleSize = sampleSize;
    }

    public long getSampleSizeAtIndex(int index) {
        if (this.sampleSize > 0L) {
            return this.sampleSize;
        }
        return this.sampleSizes[index];
    }

    public long getSampleCount() {
        if (this.sampleSize > 0L) {
            return this.sampleCount;
        }
        return this.sampleSizes.length;
    }

    public long[] getSampleSizes() {
        return this.sampleSizes;
    }

    public void setSampleSizes(long[] sampleSizes) {
        this.sampleSizes = sampleSizes;
    }

    protected long getContentSize() {
        return 8 + (this.sampleSize == 0L ? this.sampleSizes.length * 4 : 0);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        assert ((long)((int)size) == size);
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.sampleSize = in.readUInt32();
        this.sampleCount = in.readUInt32();
        if (this.sampleCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE samples!");
        }
        if (this.sampleSize == 0L) {
            this.sampleSizes = new long[(int)this.sampleCount];
            int i = 0;
            while ((long)i < this.sampleCount) {
                this.sampleSizes[i] = in.readUInt32();
                ++i;
            }
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.sampleSize);
        if (this.sampleSize == 0L) {
            isos.writeUInt32(this.sampleSizes.length);
            for (long sampleSize1 : this.sampleSizes) {
                isos.writeUInt32(sampleSize1);
            }
        } else {
            isos.writeUInt32(this.sampleCount);
        }
    }

    public String toString() {
        return "SampleSizeBox[sampleSize=" + this.getSampleSize() + ";sampleCount=" + this.getSampleCount() + "]";
    }
}

