/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeToSampleBox
extends AbstractFullBox {
    public static final String TYPE = "stts";
    List<Entry> entries = Collections.emptyList();

    public TimeToSampleBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        return 4 + this.entries.size() * 8;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.entries = new ArrayList<Entry>((int)entryCount);
        int i = 0;
        while ((long)i < entryCount) {
            this.entries.add(new Entry(in.readUInt32(), in.readUInt32()));
            ++i;
        }
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            isos.writeUInt32(entry.getCount());
            isos.writeUInt32(entry.getDelta());
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "TimeToSampleBox[entryCount=" + this.entries.size() + "]";
    }

    public static long[] blowupTimeToSamples(List<Entry> entries) {
        long numOfSamples = 0L;
        for (Entry entry : entries) {
            numOfSamples += entry.getCount();
        }
        assert (numOfSamples <= Integer.MAX_VALUE);
        long[] decodingTime = new long[(int)numOfSamples];
        int current = 0;
        for (Entry entry : entries) {
            int i = 0;
            while ((long)i < entry.getCount()) {
                decodingTime[current++] = entry.getDelta();
                ++i;
            }
        }
        return decodingTime;
    }

    public static class Entry {
        long count;
        long delta;

        public Entry(long count, long delta) {
            this.count = count;
            this.delta = delta;
        }

        public long getCount() {
            return this.count;
        }

        public long getDelta() {
            return this.delta;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void setDelta(long delta) {
            this.delta = delta;
        }

        public String toString() {
            return "Entry{count=" + this.count + ", delta=" + this.delta + '}';
        }
    }
}

