/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractTrackEncryptionBox
extends AbstractFullBox {
    int defaultAlgorithmId;
    int defaultIvSize;
    byte[] default_KID;

    protected AbstractTrackEncryptionBox(String type) {
        super(type);
    }

    public int getDefaultAlgorithmId() {
        return this.defaultAlgorithmId;
    }

    public void setDefaultAlgorithmId(int defaultAlgorithmId) {
        this.defaultAlgorithmId = defaultAlgorithmId;
    }

    public int getDefaultIvSize() {
        return this.defaultIvSize;
    }

    public void setDefaultIvSize(int defaultIvSize) {
        this.defaultIvSize = defaultIvSize;
    }

    public byte[] getDefault_KID() {
        return this.default_KID;
    }

    public void setDefault_KID(byte[] default_KID) {
        this.default_KID = default_KID;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt24(this.defaultAlgorithmId);
        os.writeUInt8(this.defaultIvSize);
        os.write(this.default_KID);
    }

    protected long getContentSize() {
        return 20L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.defaultAlgorithmId = in.readUInt24();
        this.defaultIvSize = in.readUInt8();
        this.default_KID = in.read(16);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTrackEncryptionBox that = (AbstractTrackEncryptionBox)o;
        if (this.defaultAlgorithmId != that.defaultAlgorithmId) {
            return false;
        }
        if (this.defaultIvSize != that.defaultIvSize) {
            return false;
        }
        return Arrays.equals(this.default_KID, that.default_KID);
    }

    public int hashCode() {
        int result = this.defaultAlgorithmId;
        result = 31 * result + this.defaultIvSize;
        result = 31 * result + (this.default_KID != null ? Arrays.hashCode(this.default_KID) : 0);
        return result;
    }
}

