/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.ultraviolet;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class BaseLocationBox
extends AbstractFullBox {
    String baseLocation;
    String purchaseLocation;

    public BaseLocationBox() {
        super(IsoFile.fourCCtoBytes("bloc"));
    }

    public BaseLocationBox(String baseLocation, String purchaseLocation) {
        super(IsoFile.fourCCtoBytes("bloc"));
        this.baseLocation = baseLocation;
        this.purchaseLocation = purchaseLocation;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public String getPurchaseLocation() {
        return this.purchaseLocation;
    }

    public void setPurchaseLocation(String purchaseLocation) {
        this.purchaseLocation = purchaseLocation;
    }

    protected long getContentSize() {
        return 1024L;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringZeroTerm(this.baseLocation);
        os.write(new byte[256 - IsoFile.utf8StringLengthInBytes(this.baseLocation) - 1]);
        os.writeStringZeroTerm(this.purchaseLocation);
        os.write(new byte[256 - IsoFile.utf8StringLengthInBytes(this.purchaseLocation) - 1]);
        os.write(new byte[512]);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.baseLocation = in.readString();
        in.skip(256 - IsoFile.utf8StringLengthInBytes(this.baseLocation) - 1);
        this.purchaseLocation = in.readString();
        in.skip(256 - IsoFile.utf8StringLengthInBytes(this.purchaseLocation) - 1);
        in.skip(512L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseLocationBox that = (BaseLocationBox)o;
        if (this.baseLocation != null ? !this.baseLocation.equals(that.baseLocation) : that.baseLocation != null) {
            return false;
        }
        return !(this.purchaseLocation != null ? !this.purchaseLocation.equals(that.purchaseLocation) : that.purchaseLocation != null);
    }

    public int hashCode() {
        int result = this.baseLocation != null ? this.baseLocation.hashCode() : 0;
        result = 31 * result + (this.purchaseLocation != null ? this.purchaseLocation.hashCode() : 0);
        return result;
    }
}

