/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.h264.AccessUnit;
import com.googlecode.mp4parser.h264.AccessUnitSource;
import com.googlecode.mp4parser.h264.NALUnitReader;
import com.googlecode.mp4parser.h264.StreamParams;
import com.googlecode.mp4parser.h264.model.NALUnit;
import com.googlecode.mp4parser.h264.model.NALUnitType;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import com.googlecode.mp4parser.h264.model.SliceHeader;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import com.googlecode.mp4parser.h264.read.SliceHeaderReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AccessUnitSourceImpl
implements AccessUnitSource,
StreamParams {
    private Map<Integer, SeqParameterSet> seqParameterSetMap = new HashMap<Integer, SeqParameterSet>();
    private Map<Integer, PictureParameterSet> pictureParameterSetMap = new HashMap<Integer, PictureParameterSet>();
    NALUnitReader nalUnitReader;
    IsoBufferWrapper currentNal;
    SliceHeaderReader sliceHeaderReader = new SliceHeaderReader(this);
    static Set<NALUnitType> nal_type_ok_for_sample = new HashSet<NALUnitType>(){
        {
            this.add(NALUnitType.NON_IDR_SLICE);
            this.add(NALUnitType.SLICE_PART_A);
            this.add(NALUnitType.SLICE_PART_B);
            this.add(NALUnitType.SLICE_PART_C);
            this.add(NALUnitType.IDR_SLICE);
            this.add(NALUnitType.SEI);
            this.add(NALUnitType.AUX_SLICE);
        }
    };

    public AccessUnitSourceImpl(NALUnitReader nalUnitReader) throws IOException {
        this.nalUnitReader = nalUnitReader;
        this.currentNal = nalUnitReader.nextNALUnit();
    }

    public AccessUnit nextAccessUnit() throws IOException {
        if (this.currentNal == null) {
            return null;
        }
        LinkedList<IsoBufferWrapper> au = new LinkedList<IsoBufferWrapper>();
        NALUnit oldNu = null;
        SliceHeader oldSh = null;
        boolean nalEnd = false;
        do {
            this.currentNal.position(0L);
            NALUnit nu = NALUnit.read(this.currentNal);
            if (nu.type == NALUnitType.SPS) {
                SeqParameterSet sps = SeqParameterSet.read(this.currentNal);
                this.seqParameterSetMap.put(sps.seq_parameter_set_id, sps);
                continue;
            }
            if (nu.type == NALUnitType.PPS) {
                PictureParameterSet pps = PictureParameterSet.read(this.currentNal);
                this.pictureParameterSetMap.put(pps.pic_parameter_set_id, pps);
                continue;
            }
            if (!nal_type_ok_for_sample.contains(nu.type)) continue;
            if (nu.type == NALUnitType.IDR_SLICE || nu.type == NALUnitType.NON_IDR_SLICE) {
                SliceHeader sh = this.sliceHeaderReader.read(nu, new CAVLCReader(this.currentNal));
                if (oldNu != null && oldSh != null && !this.sameAccessUnit(oldNu, nu, oldSh, sh)) {
                    nalEnd = true;
                    continue;
                }
                oldNu = nu;
                oldSh = sh;
                this.currentNal.position(0L);
                au.add(this.currentNal);
                continue;
            }
            if (oldNu != null && nu.type == NALUnitType.SEI) {
                nalEnd = true;
                continue;
            }
            this.currentNal.position(0L);
            au.add(this.currentNal);
        } while (!nalEnd && (this.currentNal = this.nalUnitReader.nextNALUnit()) != null);
        return new AccessUnitImpl(au);
    }

    public SeqParameterSet getSPS(int id) {
        return this.seqParameterSetMap.get(id);
    }

    public PictureParameterSet getPPS(int id) {
        return this.pictureParameterSetMap.get(id);
    }

    private boolean sameAccessUnit(NALUnit nu1, NALUnit nu2, SliceHeader sh1, SliceHeader sh2) {
        if (sh1.pic_parameter_set_id != sh2.pic_parameter_set_id) {
            return false;
        }
        if (sh1.frame_num != sh2.frame_num) {
            return false;
        }
        PictureParameterSet pps = this.pictureParameterSetMap.get(sh1.pic_parameter_set_id);
        SeqParameterSet sps = this.seqParameterSetMap.get(pps.seq_parameter_set_id);
        if (sps.pic_order_cnt_type == 0 && sh1.pic_order_cnt_lsb != sh2.pic_order_cnt_lsb) {
            return false;
        }
        if (sps.pic_order_cnt_type == 1 && (sh1.delta_pic_order_cnt[0] != sh2.delta_pic_order_cnt[0] || sh1.delta_pic_order_cnt[1] != sh2.delta_pic_order_cnt[1])) {
            return false;
        }
        if ((nu1.nal_ref_idc == 0 || nu2.nal_ref_idc == 0) && nu1.nal_ref_idc != nu2.nal_ref_idc) {
            return false;
        }
        if (nu1.type == NALUnitType.IDR_SLICE != (nu2.type == NALUnitType.IDR_SLICE)) {
            return false;
        }
        return sh1.idr_pic_id == sh2.idr_pic_id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AccessUnitImpl
    implements AccessUnit {
        LinkedList<IsoBufferWrapper> nals;

        private AccessUnitImpl(List<IsoBufferWrapper> nals) {
            this.nals = new LinkedList<IsoBufferWrapper>(nals);
        }

        @Override
        public IsoBufferWrapper nextNALUnit() throws IOException {
            try {
                return this.nals.pop();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

