/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.rest.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.core.convert.converter.Converter;

public class Jackson2QnameDeserializer
extends JsonDeserializer<QName>
implements Converter<String, QName> {
    private NamespaceService namespaceService;

    public Jackson2QnameDeserializer(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public Class<?> handledType() {
        return QName.class;
    }

    public QName deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String qname = jp.getText();
        return QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)qname);
    }

    public QName convert(String qname) {
        return QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)qname);
    }
}

