/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.rest.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class Jackson2QnameSerializer
extends StdSerializer<QName> {
    private static final long serialVersionUID = 1L;
    private NamespaceService namespaceService;

    public Jackson2QnameSerializer(NamespaceService namespaceService) {
        super(QName.class);
        this.namespaceService = namespaceService;
    }

    public void serialize(QName value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        String qNameString = QName.resolveToQNameString((NamespacePrefixResolver)this.namespaceService, (String)value.toString());
        jgen.writeString(qNameString);
    }

    public Class<QName> handledType() {
        return QName.class;
    }
}

