/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.CustomBuildScanEnhancements;
import com.gradle.CustomGradleEnterpriseConfig;
import com.gradle.GroovyScriptUserData;
import com.gradle.maven.extension.api.GradleEnterpriseApi;
import com.gradle.maven.extension.api.GradleEnterpriseListener;
import com.gradle.maven.extension.api.cache.BuildCacheApi;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=GradleEnterpriseListener.class, hint="common-custom-user-data", description="Captures common custom user data in Maven build scans")
public final class CommonCustomUserDataGradleEnterpriseListener
implements GradleEnterpriseListener {
    private final Logger logger = LoggerFactory.getLogger(CommonCustomUserDataGradleEnterpriseListener.class);

    public void configure(GradleEnterpriseApi api, MavenSession session) throws Exception {
        this.logger.debug("Executing extension: " + this.getClass().getSimpleName());
        CustomGradleEnterpriseConfig customGradleEnterpriseConfig = new CustomGradleEnterpriseConfig();
        this.logger.debug("Configuring Gradle Enterprise");
        customGradleEnterpriseConfig.configureGradleEnterprise(api);
        this.logger.debug("Finished configuring Gradle Enterprise");
        this.logger.debug("Configuring build scan publishing and applying build scan enhancements");
        BuildScanApi buildScan = api.getBuildScan();
        customGradleEnterpriseConfig.configureBuildScanPublishing(buildScan);
        new CustomBuildScanEnhancements(buildScan, session).apply();
        this.logger.debug("Finished configuring build scan publishing and applying build scan enhancements");
        this.logger.debug("Configuring build cache");
        BuildCacheApi buildCache = api.getBuildCache();
        customGradleEnterpriseConfig.configureBuildCache(buildCache);
        this.logger.debug("Finished configuring build cache");
        GroovyScriptUserData.evaluate(session, api, this.logger);
    }
}

