/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDAttribute;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDSubset;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDValidatorBase;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StructValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.EntityDecl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ElementId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ElementIdMap;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class DTDValidator
extends DTDValidatorBase {
    protected boolean mReportDuplicateErrors = false;
    protected ElementIdMap mIdMap = null;
    protected StructValidator[] mValidators = new StructValidator[16];
    protected BitSet mCurrSpecialAttrs = null;
    protected boolean mCurrHasAnyFixed = false;
    protected BitSet mTmpSpecialAttrs;

    public DTDValidator(DTDSubset dTDSubset, ValidationContext validationContext, boolean bl2, Map<PrefixedName, DTDElement> map, Map<String, EntityDecl> map2) {
        super(dTDSubset, validationContext, bl2, map, map2);
    }

    @Override
    public final boolean reallyValidating() {
        return true;
    }

    @Override
    public void validateElementStart(String string, String string2, String string3) throws XMLStreamException {
        String string4;
        StructValidator structValidator;
        this.mTmpKey.reset(string3, string);
        DTDElement dTDElement = (DTDElement)this.mElemSpecs.get(this.mTmpKey);
        int n2 = this.mElemCount++;
        if (n2 >= this.mElems.length) {
            this.mElems = (DTDElement[])DataUtil.growArrayBy50Pct(this.mElems);
            this.mValidators = (StructValidator[])DataUtil.growArrayBy50Pct(this.mValidators);
        }
        this.mElems[n2] = this.mCurrElem = dTDElement;
        if (dTDElement == null || !dTDElement.isDefined()) {
            this.reportValidationProblem(ErrorConsts.ERR_VLD_UNKNOWN_ELEM, this.mTmpKey.toString());
        }
        StructValidator structValidator2 = structValidator = n2 > 0 ? this.mValidators[n2 - 1] : null;
        if (structValidator != null && dTDElement != null && (string4 = structValidator.tryToValidate(dTDElement.getName())) != null) {
            int n3 = string4.indexOf("$END");
            String string5 = this.mElems[n2 - 1].toString();
            if (n3 >= 0) {
                string4 = string4.substring(0, n3) + "</" + string5 + ">" + string4.substring(n3 + 4);
            }
            this.reportValidationProblem("Validation error, encountered element <" + dTDElement.getName() + "> as a child of <" + string5 + ">: " + string4);
        }
        this.mAttrCount = 0;
        this.mIdAttrIndex = -2;
        if (dTDElement == null) {
            this.mValidators[n2] = null;
            this.mCurrAttrDefs = NO_ATTRS;
            this.mCurrHasAnyFixed = false;
            this.mCurrSpecialAttrs = null;
        } else {
            this.mValidators[n2] = dTDElement.getValidator();
            this.mCurrAttrDefs = dTDElement.getAttributes();
            if (this.mCurrAttrDefs == null) {
                this.mCurrAttrDefs = NO_ATTRS;
            }
            this.mCurrHasAnyFixed = dTDElement.hasFixedAttrs();
            int n4 = dTDElement.getSpecialCount();
            if (n4 == 0) {
                this.mCurrSpecialAttrs = null;
            } else {
                BitSet bitSet = this.mTmpSpecialAttrs;
                if (bitSet == null) {
                    this.mTmpSpecialAttrs = bitSet = new BitSet(n4);
                } else {
                    bitSet.clear();
                }
                this.mCurrSpecialAttrs = bitSet;
            }
        }
    }

    @Override
    public String validateAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        String string5;
        String string6;
        int n2;
        int n3;
        DTDAttribute dTDAttribute = (DTDAttribute)this.mCurrAttrDefs.get(this.mTmpKey.reset(string3, string));
        if (dTDAttribute == null) {
            if (this.mCurrElem != null) {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_UNKNOWN_ATTR, this.mCurrElem.toString(), this.mTmpKey.toString());
            }
            return string4;
        }
        if ((n3 = this.mAttrCount++) >= this.mAttrSpecs.length) {
            this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
        }
        this.mAttrSpecs[n3] = dTDAttribute;
        if (this.mCurrSpecialAttrs != null && (n2 = dTDAttribute.getSpecialIndex()) >= 0) {
            this.mCurrSpecialAttrs.set(n2);
        }
        String string7 = dTDAttribute.validate(this, string4, this.mNormAttrs);
        if (this.mCurrHasAnyFixed && dTDAttribute.isFixed() && !(string6 = string7 == null ? string4 : string7).equals(string5 = dTDAttribute.getDefaultValue(this.mContext, this))) {
            this.reportValidationProblem("Value of attribute \"" + dTDAttribute + "\" (element <" + this.mCurrElem + ">) not \"" + string5 + "\" as expected, but \"" + string6 + "\"");
        }
        return string7;
    }

    @Override
    public String validateAttribute(String string, String string2, String string3, char[] cArray, int n2, int n3) throws XMLStreamException {
        int n4;
        int n5;
        DTDAttribute dTDAttribute = (DTDAttribute)this.mCurrAttrDefs.get(this.mTmpKey.reset(string3, string));
        if (dTDAttribute == null) {
            if (this.mCurrElem != null) {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_UNKNOWN_ATTR, this.mCurrElem.toString(), this.mTmpKey.toString());
            }
            return new String(cArray, n2, n3 - n2);
        }
        if ((n5 = this.mAttrCount++) >= this.mAttrSpecs.length) {
            this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
        }
        this.mAttrSpecs[n5] = dTDAttribute;
        if (this.mCurrSpecialAttrs != null && (n4 = dTDAttribute.getSpecialIndex()) >= 0) {
            this.mCurrSpecialAttrs.set(n4);
        }
        String string4 = dTDAttribute.validate(this, cArray, n2, n3, this.mNormAttrs);
        if (this.mCurrHasAnyFixed && dTDAttribute.isFixed()) {
            String string5 = dTDAttribute.getDefaultValue(this.mContext, this);
            boolean bl2 = string4 == null ? StringUtil.matches(string5, cArray, n2, n3 - n2) : string5.equals(string4);
            if (!bl2) {
                String string6 = string4 == null ? new String(cArray, n2, n3 - n2) : string4;
                this.reportValidationProblem("Value of #FIXED attribute \"" + dTDAttribute + "\" (element <" + this.mCurrElem + ">) not \"" + string5 + "\" as expected, but \"" + string6 + "\"");
            }
        }
        return string4;
    }

    @Override
    public int validateElementAndAttributes() throws XMLStreamException {
        DTDElement dTDElement = this.mCurrElem;
        if (dTDElement == null) {
            return 4;
        }
        if (this.mCurrSpecialAttrs != null) {
            BitSet bitSet = this.mCurrSpecialAttrs;
            int n2 = dTDElement.getSpecialCount();
            int n3 = bitSet.nextClearBit(0);
            while (n3 < n2) {
                List<DTDAttribute> list = dTDElement.getSpecialAttrs();
                DTDAttribute dTDAttribute = list.get(n3);
                if (dTDAttribute.isRequired()) {
                    this.reportValidationProblem("Required attribute \"{0}\" missing from element <{1}>", dTDAttribute, dTDElement);
                } else {
                    this.doAddDefaultValue(dTDAttribute);
                }
                n3 = bitSet.nextClearBit(n3 + 1);
            }
        }
        return dTDElement.getAllowedContent();
    }

    @Override
    public int validateElementEnd(String string, String string2, String string3) throws XMLStreamException {
        Object object;
        int n2 = this.mElemCount - 1;
        if (n2 < 0) {
            return 1;
        }
        this.mElemCount = n2;
        DTDElement dTDElement = this.mElems[n2];
        this.mElems[n2] = null;
        StructValidator structValidator = this.mValidators[n2];
        this.mValidators[n2] = null;
        if (structValidator != null && (object = structValidator.fullyValid()) != null) {
            this.reportValidationProblem("Validation error, element </" + dTDElement + ">: " + (String)object);
        }
        if (n2 < 1) {
            return 1;
        }
        object = this.mElems[n2 - 1];
        return object == null ? 4 : ((DTDElement)object).getAllowedContent();
    }

    @Override
    public void validationCompleted(boolean bl2) throws XMLStreamException {
        this.checkIdRefs();
    }

    @Override
    protected ElementIdMap getIdMap() {
        if (this.mIdMap == null) {
            this.mIdMap = new ElementIdMap();
        }
        return this.mIdMap;
    }

    protected void checkIdRefs() throws XMLStreamException {
        ElementId elementId;
        if (this.mIdMap != null && (elementId = this.mIdMap.getFirstUndefined()) != null) {
            this.reportValidationProblem("Undefined id '" + elementId.getId() + "': referenced from element <" + elementId.getElemName() + ">, attribute '" + elementId.getAttrName() + "'", elementId.getLocation());
        }
    }
}

