/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import java.io.Serializable;
import java.util.function.BiPredicate;

public abstract class Equivalence<T>
implements BiPredicate<T, T> {
    protected Equivalence() {
    }

    public final boolean equivalent(T t2, T t3) {
        if (t2 == t3) {
            return true;
        }
        if (t2 == null || t3 == null) {
            return false;
        }
        return this.doEquivalent(t2, t3);
    }

    @Override
    @Deprecated
    public final boolean test(T t2, T t3) {
        return this.equivalent(t2, t3);
    }

    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(T t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    protected abstract int doHash(T var1);

    public static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    static final class Identity
    extends Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();

        Identity() {
        }

        @Override
        protected boolean doEquivalent(Object object, Object object2) {
            return false;
        }

        @Override
        protected int doHash(Object object) {
            return System.identityHashCode(object);
        }
    }

    static final class Equals
    extends Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();

        Equals() {
        }

        @Override
        protected boolean doEquivalent(Object object, Object object2) {
            return object.equals(object2);
        }

        @Override
        protected int doHash(Object object) {
            return object.hashCode();
        }
    }
}

