/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractRangeSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.PeekingIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Range;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableSortedSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.List;

public final class ImmutableRangeSet<C extends Comparable>
extends AbstractRangeSet<C>
implements Serializable {
    private static final ImmutableRangeSet<Comparable<?>> EMPTY = new ImmutableRangeSet(ImmutableList.of());
    private static final ImmutableRangeSet<Comparable<?>> ALL = new ImmutableRangeSet(ImmutableList.of(Range.all()));
    private final transient ImmutableList<Range<C>> ranges;

    public static <C extends Comparable> ImmutableRangeSet<C> of() {
        return EMPTY;
    }

    static <C extends Comparable> ImmutableRangeSet<C> all() {
        return ALL;
    }

    ImmutableRangeSet(ImmutableList<Range<C>> immutableList) {
        this.ranges = immutableList;
    }

    @Override
    public ImmutableSet<Range<C>> asRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableSet.of();
        }
        return new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering());
    }

    public static <C extends Comparable<?>> Builder<C> builder() {
        return new Builder();
    }

    public static class Builder<C extends Comparable<?>> {
        private final List<Range<C>> ranges = Lists.newArrayList();

        public Builder<C> add(Range<C> range) {
            Preconditions.checkArgument(!range.isEmpty(), "range must not be empty, but was %s", range);
            this.ranges.add(range);
            return this;
        }

        public Builder<C> addAll(Iterable<Range<C>> iterable) {
            for (Range<C> range : iterable) {
                this.add(range);
            }
            return this;
        }

        Builder<C> combine(Builder<C> builder) {
            this.addAll(builder.ranges);
            return this;
        }

        public ImmutableRangeSet<C> build() {
            Serializable serializable;
            ImmutableList.Builder builder = new ImmutableList.Builder(this.ranges.size());
            Collections.sort(this.ranges, Range.rangeLexOrdering());
            PeekingIterator<Range<C>> peekingIterator = Iterators.peekingIterator(this.ranges.iterator());
            while (peekingIterator.hasNext()) {
                Range<C> range;
                serializable = peekingIterator.next();
                while (peekingIterator.hasNext() && ((Range)serializable).isConnected(range = peekingIterator.peek())) {
                    Preconditions.checkArgument(((Range)serializable).intersection(range).isEmpty(), "Overlapping ranges not permitted but found %s overlapping %s", serializable, range);
                    serializable = ((Range)serializable).span(peekingIterator.next());
                }
                builder.add(serializable);
            }
            serializable = builder.build();
            if (((AbstractCollection)((Object)serializable)).isEmpty()) {
                return ImmutableRangeSet.of();
            }
            if (((AbstractCollection)((Object)serializable)).size() == 1 && ((Range)Iterables.getOnlyElement(serializable)).equals(Range.all())) {
                return ImmutableRangeSet.all();
            }
            return new ImmutableRangeSet(serializable);
        }
    }
}

