/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ArrayUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.Validate;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MemberUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    public static Object invokeMethod(Object object, boolean bl2, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeMethod(object, bl2, string, objectArray, ClassUtils.toClass(objectArray));
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        String string2;
        Objects.requireNonNull(object, "object");
        classArray = ArrayUtils.nullToEmpty(classArray);
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?> clazz = object.getClass();
        if (bl2) {
            string2 = "No such method: ";
            method = MethodUtils.getMatchingMethod(clazz, string, classArray);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            string2 = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray);
        }
        if (method == null) {
            throw new NoSuchMethodException(string2 + string + "() on object: " + clazz.getName());
        }
        objectArray = MethodUtils.toVarArgs(method, objectArray);
        return method.invoke(object, objectArray);
    }

    private static Object[] toVarArgs(Method method, Object[] objectArray) {
        if (method.isVarArgs()) {
            Class<?>[] classArray = method.getParameterTypes();
            objectArray = MethodUtils.getVarArgs(objectArray, classArray);
        }
        return objectArray;
    }

    static Object[] getVarArgs(Object[] objectArray, Class<?>[] classArray) {
        if (objectArray.length == classArray.length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1].getClass().equals(classArray[classArray.length - 1]))) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[classArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, classArray.length - 1);
        Class<?> clazz = classArray[classArray.length - 1].getComponentType();
        int n2 = objectArray.length - classArray.length + 1;
        Object object = Array.newInstance(ClassUtils.primitiveToWrapper(clazz), n2);
        System.arraycopy(objectArray, classArray.length - 1, object, 0, n2);
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray2[classArray.length - 1] = object;
        return objectArray2;
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (ClassUtils.isPublic(clazz)) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!ClassUtils.isPublic(clazz2)) continue;
            try {
                return clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2;
            for (Class<?> clazz2 : classArray2 = clazz.getInterfaces()) {
                if (!ClassUtils.isPublic(clazz2)) continue;
                try {
                    return clazz2.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz2, string, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return MemberUtils.setAccessibleWorkaround(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object;
            Method[] methodArray = clazz.getMethods();
            List list = Stream.of(methodArray).filter(method -> method.getName().equals(string) && MemberUtils.isMatchingMethod(method, classArray)).collect(Collectors.toList());
            list.sort(METHOD_BY_SIGNATURE);
            Method method2 = null;
            for (GenericDeclaration genericDeclaration : list) {
                object = MethodUtils.getAccessibleMethod(genericDeclaration);
                if (object == null || method2 != null && MemberUtils.compareMethodFit((Method)object, method2, classArray) >= 0) continue;
                method2 = object;
            }
            if (method2 != null) {
                MemberUtils.setAccessibleWorkaround(method2);
            }
            if (method2 != null && method2.isVarArgs() && method2.getParameterTypes().length > 0 && classArray.length > 0) {
                String string2;
                GenericDeclaration genericDeclaration;
                Class<?>[] classArray2 = method2.getParameterTypes();
                genericDeclaration = classArray2[classArray2.length - 1].getComponentType();
                object = ClassUtils.primitiveToWrapper(genericDeclaration).getName();
                Class<?> clazz2 = classArray[classArray.length - 1];
                String string3 = clazz2 == null ? null : clazz2.getName();
                String string4 = string2 = clazz2 == null ? null : clazz2.getSuperclass().getName();
                if (string3 != null && string2 != null && !((String)object).equals(string3) && !((String)object).equals(string2)) {
                    return null;
                }
            }
            return method2;
        }
    }

    public static Method getMatchingMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Object object2;
        Objects.requireNonNull(clazz, "cls");
        Validate.notEmpty(string, "methodName", new Object[0]);
        List list = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(string)).collect(Collectors.toList());
        ClassUtils.getAllSuperclasses(clazz).stream().map(Class::getDeclaredMethods).flatMap(Stream::of).filter(method -> method.getName().equals(string)).forEach(list::add);
        for (Object object2 : list) {
            if (!Arrays.deepEquals(((Method)object2).getParameterTypes(), classArray)) continue;
            return object2;
        }
        TreeMap treeMap = new TreeMap();
        list.stream().filter(method -> ClassUtils.isAssignable(classArray, method.getParameterTypes(), true)).forEach(method -> {
            int n3 = MethodUtils.distance(classArray, method.getParameterTypes());
            List list = treeMap.computeIfAbsent(n3, n2 -> new ArrayList());
            list.add(method);
        });
        if (treeMap.isEmpty()) {
            return null;
        }
        object2 = (List)treeMap.values().iterator().next();
        if (object2.size() == 1 || !Objects.equals(((Method)object2.get(0)).getDeclaringClass(), ((Method)object2.get(1)).getDeclaringClass())) {
            return (Method)object2.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", string + Stream.of(classArray).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), clazz.getName(), object2.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    private static int distance(Class<?>[] classArray, Class<?>[] classArray2) {
        int n2 = 0;
        if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
            return -1;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz = classArray[i2];
            Class<?> clazz2 = classArray2[i2];
            if (clazz == null || clazz.equals(clazz2)) continue;
            if (ClassUtils.isAssignable(clazz, clazz2, true) && !ClassUtils.isAssignable(clazz, clazz2, false)) {
                ++n2;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }
}

