/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.client.methods;

import com.gradle.maven.extension.internal.dep.org.apache.http.Consts;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntityEnclosingRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.NameValuePair;
import com.gradle.maven.extension.internal.dep.org.apache.http.ProtocolVersion;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.config.RequestConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.Configurable;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpRequestBase;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpUriRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.utils.URIBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.utils.URLEncodedUtils;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.ContentType;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.HeaderGroup;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HTTP;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;

public class RequestBuilder {
    private String method;
    private Charset charset = Consts.UTF_8;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headerGroup;
    private HttpEntity entity;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    RequestBuilder(String string) {
        this.method = string;
    }

    RequestBuilder() {
        this(null);
    }

    public static RequestBuilder copy(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "HTTP request");
        return new RequestBuilder().doCopy(httpRequest);
    }

    private RequestBuilder doCopy(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return this;
        }
        this.method = httpRequest.getRequestLine().getMethod();
        this.version = httpRequest.getRequestLine().getProtocolVersion();
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.clear();
        this.headerGroup.setHeaders(httpRequest.getAllHeaders());
        this.parameters = null;
        this.entity = null;
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            ContentType contentType = ContentType.get(httpEntity);
            if (contentType != null && contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                try {
                    this.charset = contentType.getCharset();
                    List<NameValuePair> list = URLEncodedUtils.parse(httpEntity);
                    if (!list.isEmpty()) {
                        this.parameters = list;
                    }
                }
                catch (IOException iOException) {}
            } else {
                this.entity = httpEntity;
            }
        }
        this.uri = httpRequest instanceof HttpUriRequest ? ((HttpUriRequest)httpRequest).getURI() : URI.create(httpRequest.getRequestLine().getUri());
        this.config = httpRequest instanceof Configurable ? ((Configurable)((Object)httpRequest)).getConfig() : null;
        return this;
    }

    public RequestBuilder setUri(URI uRI) {
        this.uri = uRI;
        return this;
    }

    public HttpUriRequest build() {
        HttpRequestBase httpRequestBase;
        URI uRI = this.uri != null ? this.uri : URI.create("/");
        HttpEntity httpEntity = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (httpEntity == null && ("POST".equalsIgnoreCase(this.method) || "PUT".equalsIgnoreCase(this.method))) {
                httpEntity = new UrlEncodedFormEntity(this.parameters, this.charset != null ? this.charset : HTTP.DEF_CONTENT_CHARSET);
            } else {
                try {
                    uRI = new URIBuilder(uRI).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (httpEntity == null) {
            httpRequestBase = new InternalRequest(this.method);
        } else {
            InternalEntityEclosingRequest internalEntityEclosingRequest = new InternalEntityEclosingRequest(this.method);
            internalEntityEclosingRequest.setEntity(httpEntity);
            httpRequestBase = internalEntityEclosingRequest;
        }
        httpRequestBase.setProtocolVersion(this.version);
        httpRequestBase.setURI(uRI);
        if (this.headerGroup != null) {
            httpRequestBase.setHeaders(this.headerGroup.getAllHeaders());
        }
        httpRequestBase.setConfig(this.config);
        return httpRequestBase;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RequestBuilder [method=");
        stringBuilder.append(this.method);
        stringBuilder.append(", charset=");
        stringBuilder.append(this.charset);
        stringBuilder.append(", version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", uri=");
        stringBuilder.append(this.uri);
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(this.headerGroup);
        stringBuilder.append(", entity=");
        stringBuilder.append(this.entity);
        stringBuilder.append(", parameters=");
        stringBuilder.append(this.parameters);
        stringBuilder.append(", config=");
        stringBuilder.append(this.config);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static class InternalEntityEclosingRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        InternalEntityEclosingRequest(String string) {
            this.method = string;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }

    static class InternalRequest
    extends HttpRequestBase {
        private final String method;

        InternalRequest(String string) {
            this.method = string;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }
}

