/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.AbstractHttpClientTransport;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ManagedSelector;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.SelectorManager;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.SocketChannelEndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;

public abstract class AbstractConnectorHttpClientTransport
extends AbstractHttpClientTransport {
    private final int selectors;
    private SelectorManager selectorManager;

    protected AbstractConnectorHttpClientTransport(int n2) {
        this.selectors = n2;
    }

    public int getSelectors() {
        return this.selectors;
    }

    @Override
    protected void doStart() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        this.selectorManager = this.newSelectorManager(httpClient);
        this.selectorManager.setConnectTimeout(httpClient.getConnectTimeout());
        this.addBean(this.selectorManager);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.selectorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(InetSocketAddress inetSocketAddress, Map<String, Object> map) {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
            HttpClient httpClient = httpDestination.getHttpClient();
            SocketAddress socketAddress = httpClient.getBindAddress();
            if (socketAddress != null) {
                socketChannel.bind(socketAddress);
            }
            this.configure(httpClient, socketChannel);
            map.put("ssl.peer.host", inetSocketAddress.getHostString());
            map.put("ssl.peer.port", inetSocketAddress.getPort());
            boolean bl2 = true;
            if (httpClient.isConnectBlocking()) {
                socketChannel.socket().connect(inetSocketAddress, (int)httpClient.getConnectTimeout());
                socketChannel.configureBlocking(false);
            } else {
                socketChannel.configureBlocking(false);
                bl2 = socketChannel.connect(inetSocketAddress);
            }
            if (bl2) {
                this.selectorManager.accept(socketChannel, map);
            } else {
                this.selectorManager.connect(socketChannel, map);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable.getClass() == SocketException.class) {
                throwable2 = new SocketException("Could not connect to " + inetSocketAddress).initCause(throwable);
            }
            try {
                if (socketChannel != null) {
                    socketChannel.close();
                }
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
            finally {
                this.connectFailed(map, throwable2);
            }
        }
    }

    protected void connectFailed(Map<String, Object> map, Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", map.get("http.destination"));
        }
        Promise promise = (Promise)map.get("http.connection.promise");
        promise.failed(throwable);
    }

    protected void configure(HttpClient httpClient, SocketChannel socketChannel) throws IOException {
        socketChannel.socket().setTcpNoDelay(httpClient.isTCPNoDelay());
    }

    protected SelectorManager newSelectorManager(HttpClient httpClient) {
        return new ClientSelectorManager(httpClient, this.getSelectors());
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        private final HttpClient client;

        protected ClientSelectorManager(HttpClient httpClient, int n2) {
            super(httpClient.getExecutor(), httpClient.getScheduler(), n2);
            this.client = httpClient;
        }

        @Override
        protected EndPoint newEndPoint(SelectableChannel selectableChannel, ManagedSelector managedSelector, SelectionKey selectionKey) {
            SocketChannelEndPoint socketChannelEndPoint = new SocketChannelEndPoint(selectableChannel, managedSelector, selectionKey, this.getScheduler());
            socketChannelEndPoint.setIdleTimeout(this.client.getIdleTimeout());
            return socketChannelEndPoint;
        }

        @Override
        public Connection newConnection(SelectableChannel selectableChannel, EndPoint endPoint, Object object) throws IOException {
            Map map = (Map)object;
            HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
            return httpDestination.getClientConnectionFactory().newConnection(endPoint, map);
        }

        @Override
        protected void connectionFailed(SelectableChannel selectableChannel, Throwable throwable, Object object) {
            Map map = (Map)object;
            AbstractConnectorHttpClientTransport.this.connectFailed(map, throwable);
        }
    }
}

