/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class URLResource
extends Resource {
    private static final Logger LOG = Log.getLogger(URLResource.class);
    protected final URL _url;
    protected final String _urlString;
    protected URLConnection _connection;
    protected InputStream _in = null;
    transient boolean _useCaches = Resource.__defaultUseCaches;

    protected URLResource(URL uRL, URLConnection uRLConnection) {
        this._url = uRL;
        this._urlString = this._url.toExternalForm();
        this._connection = uRLConnection;
    }

    protected URLResource(URL uRL, URLConnection uRLConnection, boolean bl2) {
        this(uRL, uRLConnection);
        this._useCaches = bl2;
    }

    protected synchronized boolean checkConnection() {
        if (this._connection == null) {
            try {
                this._connection = this._url.openConnection();
                this._connection.setUseCaches(this._useCaches);
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        return this._connection != null;
    }

    @Override
    public synchronized void close() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
            this._in = null;
        }
        if (this._connection != null) {
            this._connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        try {
            URLResource uRLResource = this;
            synchronized (uRLResource) {
                if (this.checkConnection() && this._in == null) {
                    this._in = this._connection.getInputStream();
                }
            }
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
        }
        return this._in != null;
    }

    @Override
    public String getName() {
        return this._url.toExternalForm();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        return this.getInputStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized InputStream getInputStream(boolean bl2) throws IOException {
        if (!this.checkConnection()) {
            throw new IOException("Invalid resource");
        }
        try {
            if (this._in != null) {
                InputStream inputStream = this._in;
                this._in = null;
                InputStream inputStream2 = inputStream;
                return inputStream2;
            }
            InputStream inputStream = this._connection.getInputStream();
            return inputStream;
        }
        finally {
            if (bl2) {
                this._connection = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection nulled", new Object[0]);
                }
            }
        }
    }

    public String toString() {
        return this._urlString;
    }

    public int hashCode() {
        return this._urlString.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof URLResource && this._urlString.equals(((URLResource)object)._urlString);
    }

    public boolean getUseCaches() {
        return this._useCaches;
    }
}

