/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.MessageTooLargeException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.ProtocolException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.OpCode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.CloseFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.PingFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.PongFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.TextFrame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.io.payload.DeMaskProcessor;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.io.payload.PayloadProcessor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

public class Parser {
    private static final Logger LOG = Log.getLogger(Parser.class);
    private final WebSocketPolicy policy;
    private final ByteBufferPool bufferPool;
    private final LongAdder messagesIn = new LongAdder();
    private State state = State.START;
    private int cursor = 0;
    private WebSocketFrame frame;
    private boolean priorDataFrame;
    private ByteBuffer payload;
    private int payloadLength;
    private PayloadProcessor maskProcessor = new DeMaskProcessor();
    private byte flagsInUse = 0;
    private IncomingFrames incomingFramesHandler;

    public Parser(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        this.bufferPool = byteBufferPool;
        this.policy = webSocketPolicy;
    }

    private void assertSanePayloadLength(long l2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} Payload Length: {} - {}", new Object[]{this.policy.getBehavior(), l2, this});
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessageTooLargeException("[int-sane!] cannot handle payload lengths larger than 2147483647");
        }
        switch (this.frame.getOpCode()) {
            case 8: {
                if (l2 == 1L) {
                    throw new ProtocolException("Invalid close frame payload length, [" + this.payloadLength + "]");
                }
            }
            case 9: 
            case 10: {
                if (l2 <= 125L) break;
                throw new ProtocolException("Invalid control frame payload length, [" + this.payloadLength + "] cannot exceed [" + 125 + "]");
            }
            case 1: {
                this.policy.assertValidTextMessageSize((int)l2);
                break;
            }
            case 2: {
                this.policy.assertValidBinaryMessageSize((int)l2);
            }
        }
    }

    public void configureFromExtensions(List<? extends Extension> list) {
        this.flagsInUse = 0;
        for (Extension extension : list) {
            if (extension.isRsv1User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x40);
            }
            if (extension.isRsv2User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x20);
            }
            if (!extension.isRsv3User()) continue;
            this.flagsInUse = (byte)(this.flagsInUse | 0x10);
        }
    }

    public IncomingFrames getIncomingFramesHandler() {
        return this.incomingFramesHandler;
    }

    public boolean isRsv1InUse() {
        return (this.flagsInUse & 0x40) != 0;
    }

    public boolean isRsv2InUse() {
        return (this.flagsInUse & 0x20) != 0;
    }

    public boolean isRsv3InUse() {
        return (this.flagsInUse & 0x10) != 0;
    }

    protected void notifyFrame(Frame frame) throws WebSocketException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} Notify {}", new Object[]{this.policy.getBehavior(), this.getIncomingFramesHandler()});
        }
        if (this.policy.getBehavior() == WebSocketBehavior.SERVER) {
            if (!frame.isMasked()) {
                throw new ProtocolException("Client MUST mask all frames (RFC-6455: Section 5.1)");
            }
        } else if (this.policy.getBehavior() == WebSocketBehavior.CLIENT && frame.isMasked()) {
            throw new ProtocolException("Server MUST NOT mask any frames (RFC-6455: Section 5.1)");
        }
        if (this.incomingFramesHandler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No IncomingFrames Handler to notify", new Object[0]);
            }
            return;
        }
        try {
            this.incomingFramesHandler.incomingFrame(frame);
        }
        catch (WebSocketException webSocketException) {
            throw webSocketException;
        }
        catch (Throwable throwable) {
            throw new WebSocketException(throwable);
        }
    }

    public void parse(ByteBuffer byteBuffer) throws WebSocketException {
        while (byteBuffer.hasRemaining()) {
            this.parseSingleFrame(byteBuffer);
        }
    }

    public void parseSingleFrame(ByteBuffer byteBuffer) throws WebSocketException {
        if (byteBuffer.remaining() <= 0) {
            return;
        }
        try {
            if (this.parseFrame(byteBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Parsed Frame: {}", new Object[]{this.policy.getBehavior(), this.frame});
                }
                this.messagesIn.increment();
                this.notifyFrame(this.frame);
                if (this.frame.isDataFrame()) {
                    this.priorDataFrame = !this.frame.isFin();
                }
                this.reset();
            }
        }
        catch (Throwable throwable) {
            byteBuffer.position(byteBuffer.limit());
            this.reset();
            if (throwable instanceof WebSocketException) {
                throw throwable;
            }
            throw new WebSocketException(throwable);
        }
    }

    private void reset() {
        if (this.frame != null) {
            this.frame.reset();
        }
        this.frame = null;
        this.bufferPool.release(this.payload);
        this.payload = null;
    }

    private boolean parseFrame(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} Parsing {} bytes", new Object[]{this.policy.getBehavior(), byteBuffer.remaining()});
        }
        while (byteBuffer.hasRemaining()) {
            switch (this.state) {
                case START: {
                    byte by2 = byteBuffer.get();
                    boolean bl2 = (by2 & 0x80) != 0;
                    byte by3 = (byte)(by2 & 0xF);
                    if (!OpCode.isKnown(by3)) {
                        throw new ProtocolException("Unknown opcode: " + by3);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} OpCode {}, fin={} rsv={}{}{}", new Object[]{this.policy.getBehavior(), OpCode.name(by3), bl2, Character.valueOf((by2 & 0x40) != 0 ? (char)'1' : '.'), Character.valueOf((by2 & 0x20) != 0 ? (char)'1' : '.'), Character.valueOf((by2 & 0x10) != 0 ? (char)'1' : '.')});
                    }
                    switch (by3) {
                        case 1: {
                            this.frame = new TextFrame();
                            if (!this.priorDataFrame) break;
                            throw new ProtocolException("Unexpected " + OpCode.name(by3) + " frame, was expecting CONTINUATION");
                        }
                        case 2: {
                            this.frame = new BinaryFrame();
                            if (!this.priorDataFrame) break;
                            throw new ProtocolException("Unexpected " + OpCode.name(by3) + " frame, was expecting CONTINUATION");
                        }
                        case 0: {
                            this.frame = new ContinuationFrame();
                            if (this.priorDataFrame) break;
                            throw new ProtocolException("CONTINUATION frame without prior !FIN");
                        }
                        case 8: {
                            this.frame = new CloseFrame();
                            if (bl2) break;
                            throw new ProtocolException("Fragmented Close Frame [" + OpCode.name(by3) + "]");
                        }
                        case 9: {
                            this.frame = new PingFrame();
                            if (bl2) break;
                            throw new ProtocolException("Fragmented Ping Frame [" + OpCode.name(by3) + "]");
                        }
                        case 10: {
                            this.frame = new PongFrame();
                            if (bl2) break;
                            throw new ProtocolException("Fragmented Pong Frame [" + OpCode.name(by3) + "]");
                        }
                    }
                    this.frame.setFin(bl2);
                    if ((by2 & 0x70) != 0) {
                        if ((by2 & 0x40) != 0) {
                            if (this.isRsv1InUse()) {
                                this.frame.setRsv1(true);
                            } else {
                                String string = "RSV1 not allowed to be set";
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(string + ": Remaining buffer: {}", BufferUtil.toDetailString(byteBuffer));
                                }
                                throw new ProtocolException(string);
                            }
                        }
                        if ((by2 & 0x20) != 0) {
                            if (this.isRsv2InUse()) {
                                this.frame.setRsv2(true);
                            } else {
                                String string = "RSV2 not allowed to be set";
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(string + ": Remaining buffer: {}", BufferUtil.toDetailString(byteBuffer));
                                }
                                throw new ProtocolException(string);
                            }
                        }
                        if ((by2 & 0x10) != 0) {
                            if (this.isRsv3InUse()) {
                                this.frame.setRsv3(true);
                            } else {
                                String string = "RSV3 not allowed to be set";
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(string + ": Remaining buffer: {}", BufferUtil.toDetailString(byteBuffer));
                                }
                                throw new ProtocolException(string);
                            }
                        }
                    }
                    this.state = State.PAYLOAD_LEN;
                    break;
                }
                case PAYLOAD_LEN: {
                    byte by4 = byteBuffer.get();
                    this.frame.setMasked((by4 & 0x80) != 0);
                    this.payloadLength = (byte)(0x7F & by4);
                    if (this.payloadLength == 127) {
                        this.payloadLength = 0;
                        this.state = State.PAYLOAD_LEN_BYTES;
                        this.cursor = 8;
                        break;
                    }
                    if (this.payloadLength == 126) {
                        this.payloadLength = 0;
                        this.state = State.PAYLOAD_LEN_BYTES;
                        this.cursor = 2;
                        break;
                    }
                    this.assertSanePayloadLength(this.payloadLength);
                    if (this.frame.isMasked()) {
                        this.state = State.MASK;
                        break;
                    }
                    if (this.payloadLength == 0) {
                        this.state = State.START;
                        return true;
                    }
                    this.maskProcessor.reset(this.frame);
                    this.state = State.PAYLOAD;
                    break;
                }
                case PAYLOAD_LEN_BYTES: {
                    byte by5 = byteBuffer.get();
                    --this.cursor;
                    this.payloadLength |= (by5 & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) break;
                    this.assertSanePayloadLength(this.payloadLength);
                    if (this.frame.isMasked()) {
                        this.state = State.MASK;
                        break;
                    }
                    if (this.payloadLength == 0) {
                        this.state = State.START;
                        return true;
                    }
                    this.maskProcessor.reset(this.frame);
                    this.state = State.PAYLOAD;
                    break;
                }
                case MASK: {
                    byte[] byArray = new byte[4];
                    this.frame.setMask(byArray);
                    if (byteBuffer.remaining() >= 4) {
                        byteBuffer.get(byArray, 0, 4);
                        if (this.payloadLength == 0) {
                            this.state = State.START;
                            return true;
                        }
                        this.maskProcessor.reset(this.frame);
                        this.state = State.PAYLOAD;
                        break;
                    }
                    this.state = State.MASK_BYTES;
                    this.cursor = 4;
                    break;
                }
                case MASK_BYTES: {
                    byte by6;
                    this.frame.getMask()[4 - this.cursor] = by6 = byteBuffer.get();
                    --this.cursor;
                    if (this.cursor != 0) break;
                    if (this.payloadLength == 0) {
                        this.state = State.START;
                        return true;
                    }
                    this.maskProcessor.reset(this.frame);
                    this.state = State.PAYLOAD;
                    break;
                }
                case PAYLOAD: {
                    this.frame.assertValid();
                    if (!this.parsePayload(byteBuffer)) break;
                    if (this.frame.getOpCode() == 8) {
                        new CloseInfo(this.frame);
                    }
                    this.state = State.START;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean parsePayload(ByteBuffer byteBuffer) {
        if (this.payloadLength == 0) {
            return true;
        }
        if (byteBuffer.hasRemaining()) {
            int n2 = this.payload == null ? 0 : this.payload.position();
            int n3 = this.payloadLength - n2;
            int n4 = byteBuffer.remaining();
            int n5 = Math.min(n4, n3);
            int n6 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + n5);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer.limit(n6);
            byteBuffer.position(byteBuffer.position() + byteBuffer2.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Window: {}", new Object[]{this.policy.getBehavior(), BufferUtil.toDetailString(byteBuffer2)});
            }
            this.maskProcessor.process(byteBuffer2);
            if (byteBuffer2.remaining() == this.payloadLength) {
                this.frame.setPayload(byteBuffer2);
                return true;
            }
            if (this.payload == null) {
                this.payload = this.bufferPool.acquire(this.payloadLength, false);
                BufferUtil.clearToFill(this.payload);
            }
            this.payload.put(byteBuffer2);
            if (this.payload.position() == this.payloadLength) {
                BufferUtil.flipToFlush(this.payload, 0);
                this.frame.setPayload(this.payload);
                return true;
            }
        }
        return false;
    }

    public void setIncomingFramesHandler(IncomingFrames incomingFrames) {
        this.incomingFramesHandler = incomingFrames;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parser@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[");
        if (this.incomingFramesHandler == null) {
            stringBuilder.append("NO_HANDLER");
        } else {
            stringBuilder.append(this.incomingFramesHandler.getClass().getSimpleName());
        }
        stringBuilder.append(",s=").append((Object)this.state);
        stringBuilder.append(",c=").append(this.cursor);
        stringBuilder.append(",len=").append(this.payloadLength);
        stringBuilder.append(",f=").append(this.frame);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static enum State {
        START,
        PAYLOAD_LEN,
        PAYLOAD_LEN_BYTES,
        MASK,
        MASK_BYTES,
        PAYLOAD;

    }
}

