/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.CollectionToArrayConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.GenericConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

final class ArrayToArrayConverter
implements ConditionalGenericConverter {
    private final CollectionToArrayConverter helperConverter;
    private final ConversionService conversionService;

    public ArrayToArrayConverter(ConversionService conversionService) {
        this.helperConverter = new CollectionToArrayConverter(conversionService);
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return this.helperConverter.matches(typeDescriptor, typeDescriptor2);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Object object2;
        if (this.conversionService instanceof GenericConversionService && (object2 = typeDescriptor2.getElementTypeDescriptor()) != null && ((GenericConversionService)this.conversionService).canBypassConvert(typeDescriptor.getElementTypeDescriptor(), (TypeDescriptor)object2)) {
            return object;
        }
        object2 = Arrays.asList(ObjectUtils.toObjectArray(object));
        return this.helperConverter.convert(object2, typeDescriptor, typeDescriptor2);
    }
}

