/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;

public class IntLiteral
extends Literal {
    private final TypedValue value;

    public IntLiteral(String string, int n2, int n3, int n4) {
        super(string, n2, n3);
        this.value = new TypedValue(n4);
        this.exitTypeDescriptor = "I";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        Integer n2 = (Integer)this.value.getValue();
        Assert.state(n2 != null, "No int value");
        if (n2 == -1) {
            methodVisitor.visitInsn(2);
        } else if (n2 >= 0 && n2 < 6) {
            methodVisitor.visitInsn(3 + n2);
        } else {
            methodVisitor.visitLdcInsn(n2);
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

