/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.PortRange;
import com.hazelcast.aws.StringUtils;
import com.hazelcast.config.InvalidConfigurationException;

final class AwsConfig {
    private final String region;
    private final String hostHeader;
    private final String securityGroupName;
    private final String tagKey;
    private final String tagValue;
    private final int connectionTimeoutSeconds;
    private final int connectionRetries;
    private final int readTimeoutSeconds;
    private final PortRange hzPort;
    private final String accessKey;
    private final String secretKey;
    private final String iamRole;
    private final String cluster;
    private final String family;
    private final String serviceName;

    private AwsConfig(String accessKey, String secretKey, String region, String iamRole, String hostHeader, String securityGroupName, String tagKey, String tagValue, int connectionTimeoutSeconds, int connectionRetries, int readTimeoutSeconds, PortRange hzPort, String cluster, String family, String serviceName) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
        this.iamRole = iamRole;
        this.hostHeader = hostHeader;
        this.securityGroupName = securityGroupName;
        this.tagKey = tagKey;
        this.tagValue = tagValue;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.connectionRetries = connectionRetries;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.hzPort = hzPort;
        this.cluster = cluster;
        this.family = family;
        this.serviceName = serviceName;
        this.validateConfig();
    }

    private void validateConfig() {
        if (this.anyOfEc2PropertiesConfigured() && this.anyOfEcsPropertiesConfigured()) {
            throw new InvalidConfigurationException("You have to configure either EC2 properties ('iam-role', 'security-group-name', 'tag-key', 'tag-value') or ECS properties ('cluster', 'family', 'service-name'). You cannot define both of them");
        }
        if (StringUtils.isNotEmpty(this.family) && StringUtils.isNotEmpty(this.serviceName)) {
            throw new InvalidConfigurationException("You cannot configure ECS discovery with both 'family' and 'service-name', these filters are mutually exclusive");
        }
        if (StringUtils.isNotEmpty(this.iamRole) && (StringUtils.isNotEmpty(this.accessKey) || StringUtils.isNotEmpty(this.secretKey))) {
            throw new InvalidConfigurationException("You cannot define both 'iam-role' and 'access-key'/'secret-key'. Choose how you want to authenticate with AWS API, either with IAM Role or with hardcoded AWS Credentials");
        }
        if (StringUtils.isEmpty(this.accessKey) && StringUtils.isNotEmpty(this.secretKey) || StringUtils.isNotEmpty(this.accessKey) && StringUtils.isEmpty(this.secretKey)) {
            throw new InvalidConfigurationException("You have to either define both ('access-key', 'secret-key') or none of them");
        }
    }

    private boolean anyOfEc2PropertiesConfigured() {
        return StringUtils.isNotEmpty(this.iamRole) || StringUtils.isNotEmpty(this.securityGroupName) || StringUtils.isNotEmpty(this.tagKey) || StringUtils.isNotEmpty(this.tagValue);
    }

    private boolean anyOfEcsPropertiesConfigured() {
        return StringUtils.isNotEmpty(this.cluster) || StringUtils.isNotEmpty(this.family) || StringUtils.isNotEmpty(this.serviceName);
    }

    static Builder builder() {
        return new Builder();
    }

    String getAccessKey() {
        return this.accessKey;
    }

    String getSecretKey() {
        return this.secretKey;
    }

    String getRegion() {
        return this.region;
    }

    String getIamRole() {
        return this.iamRole;
    }

    String getHostHeader() {
        return this.hostHeader;
    }

    String getSecurityGroupName() {
        return this.securityGroupName;
    }

    String getTagKey() {
        return this.tagKey;
    }

    String getTagValue() {
        return this.tagValue;
    }

    int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    int getConnectionRetries() {
        return this.connectionRetries;
    }

    int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    PortRange getHzPort() {
        return this.hzPort;
    }

    String getCluster() {
        return this.cluster;
    }

    String getFamily() {
        return this.family;
    }

    String getServiceName() {
        return this.serviceName;
    }

    public String toString() {
        return "AwsConfig{accessKey='***', secretKey='***', iamRole='" + this.iamRole + '\'' + ", region='" + this.region + '\'' + ", hostHeader='" + this.hostHeader + '\'' + ", securityGroupName='" + this.securityGroupName + '\'' + ", tagKey='" + this.tagKey + '\'' + ", tagValue='" + this.tagValue + '\'' + ", hzPort=" + this.hzPort + ", cluster='" + this.cluster + '\'' + ", family='" + this.family + '\'' + ", serviceName='" + this.serviceName + '\'' + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", connectionRetries=" + this.connectionRetries + ", readTimeoutSeconds=" + this.readTimeoutSeconds + '}';
    }

    static class Builder {
        private String accessKey;
        private String secretKey;
        private String region;
        private String iamRole;
        private String hostHeader;
        private String securityGroupName;
        private String tagKey;
        private String tagValue;
        private int connectionTimeoutSeconds;
        private int connectionRetries;
        private int readTimeoutSeconds;
        private PortRange hzPort;
        private String cluster;
        private String family;
        private String serviceName;

        Builder() {
        }

        Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        Builder setIamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        Builder setHostHeader(String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        Builder setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
            return this;
        }

        Builder setTagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        Builder setTagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        Builder setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        Builder setConnectionRetries(int connectionRetries) {
            this.connectionRetries = connectionRetries;
            return this;
        }

        Builder setReadTimeoutSeconds(int readTimeoutSeconds) {
            this.readTimeoutSeconds = readTimeoutSeconds;
            return this;
        }

        Builder setHzPort(PortRange hzPort) {
            this.hzPort = hzPort;
            return this;
        }

        Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        Builder setFamily(String family) {
            this.family = family;
            return this;
        }

        Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        AwsConfig build() {
            return new AwsConfig(this.accessKey, this.secretKey, this.region, this.iamRole, this.hostHeader, this.securityGroupName, this.tagKey, this.tagValue, this.connectionTimeoutSeconds, this.connectionRetries, this.readTimeoutSeconds, this.hzPort, this.cluster, this.family, this.serviceName);
        }
    }
}

