/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.security.RealmConfigCallback;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ClientCallbackHandler
implements CallbackHandler {
    private final ClientConfig clientConfig;

    public ClientCallbackHandler(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            this.handleCallback(cb);
        }
    }

    protected void handleCallback(Callback cb) throws UnsupportedCallbackException {
        RealmConfig realmCfg;
        RealmConfigCallback realmCb;
        if (cb instanceof RealmConfigCallback) {
            realmCb = (RealmConfigCallback)cb;
            realmCfg = null;
            if (this.clientConfig != null && this.clientConfig.getSecurityConfig() != null) {
                realmCfg = this.clientConfig.getSecurityConfig().getRealmConfig(realmCb.getRealmName());
            }
        } else {
            throw new UnsupportedCallbackException(cb);
        }
        realmCb.setRealmConfig(realmCfg);
    }
}

