/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl.discovery;

import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.Addresses;
import com.hazelcast.cluster.Address;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class RemoteAddressProvider
implements AddressProvider {
    private final Callable<Map<Address, Address>> getAddresses;
    private final boolean usePublic;
    private volatile Map<Address, Address> privateToPublic = new HashMap<Address, Address>();

    public RemoteAddressProvider(Callable<Map<Address, Address>> getAddresses, boolean usePublic) {
        this.getAddresses = getAddresses;
        this.usePublic = usePublic;
    }

    @Override
    public Addresses loadAddresses() throws Exception {
        this.privateToPublic = this.getAddresses.call();
        return new Addresses(this.privateToPublic.keySet());
    }

    @Override
    public Address translate(Address address) throws Exception {
        if (address == null) {
            return null;
        }
        if (!this.usePublic) {
            return address;
        }
        Address publicAddress = this.privateToPublic.get(address);
        if (publicAddress != null) {
            return publicAddress;
        }
        this.privateToPublic = this.getAddresses.call();
        return this.privateToPublic.get(address);
    }
}

