/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.log;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class SnapshotEntry
extends LogEntry
implements IdentifiedDataSerializable {
    private long groupMembersLogIndex;
    private Collection<RaftEndpoint> groupMembers;

    public SnapshotEntry() {
    }

    public SnapshotEntry(int term, long index, Object operation, long groupMembersLogIndex, Collection<RaftEndpoint> groupMembers) {
        super(term, index, operation);
        this.groupMembersLogIndex = groupMembersLogIndex;
        this.groupMembers = Collections.unmodifiableCollection(new LinkedHashSet<RaftEndpoint>(groupMembers));
    }

    public long groupMembersLogIndex() {
        return this.groupMembersLogIndex;
    }

    public Collection<RaftEndpoint> groupMembers() {
        return this.groupMembers;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeLong(this.groupMembersLogIndex);
        out.writeInt(this.groupMembers.size());
        for (RaftEndpoint endpoint : this.groupMembers) {
            out.writeObject(endpoint);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.groupMembersLogIndex = in.readLong();
        int count = in.readInt();
        this.groupMembers = new LinkedHashSet<RaftEndpoint>(count);
        for (int i = 0; i < count; ++i) {
            RaftEndpoint endpoint = (RaftEndpoint)in.readObject();
            this.groupMembers.add(endpoint);
        }
        this.groupMembers = Collections.unmodifiableCollection(this.groupMembers);
    }

    @Override
    public int getClassId() {
        return 9;
    }

    public String toString(boolean detailed) {
        return "SnapshotEntry{term=" + this.term() + ", index=" + this.index() + (detailed ? ", operation=" + this.operation() : "") + ", groupMembersLogIndex=" + this.groupMembersLogIndex + ", groupMembers=" + this.groupMembers + '}';
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public static boolean isNonInitial(SnapshotEntry entry) {
        return entry != null && entry.index() > 0L;
    }
}

