/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.gcp.RestClient;
import com.hazelcast.gcp.Utils;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.ParseException;

class GcpMetadataApi {
    private static final String METADATA_ENDPOINT = "http://metadata.google.internal";
    private final String endpoint;

    GcpMetadataApi() {
        this.endpoint = METADATA_ENDPOINT;
    }

    GcpMetadataApi(String endpoint) {
        this.endpoint = endpoint;
    }

    String currentProject() {
        String urlString = String.format("%s/computeMetadata/v1/project/project-id", this.endpoint);
        return GcpMetadataApi.callGet(urlString);
    }

    String currentZone() {
        String urlString = String.format("%s/computeMetadata/v1/instance/zone", this.endpoint);
        String zoneResponse = GcpMetadataApi.callGet(urlString);
        return Utils.lastPartOf(zoneResponse, "/");
    }

    String currentRegion() {
        int index = this.currentZone().lastIndexOf("-");
        return this.currentZone().substring(0, index);
    }

    String accessToken() {
        String urlString = String.format("%s/computeMetadata/v1/instance/service-accounts/default/token", this.endpoint);
        String accessTokenResponse = GcpMetadataApi.callGet(urlString);
        return GcpMetadataApi.extractAccessToken(accessTokenResponse);
    }

    private static String extractAccessToken(String accessTokenResponse) {
        try {
            return Json.parse(accessTokenResponse).asObject().get("access_token").asString();
        }
        catch (ParseException e) {
            throw new HazelcastException("Unable to retrieve access token. Please grant permissions to this service account if running from within the GCP network or specify the correct private key file path if running from outside the GCP.", e);
        }
    }

    private static String callGet(String urlString) {
        return RestClient.create(urlString).withHeader("Metadata-Flavor", "Google").get();
    }
}

