/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.store;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.internal.eviction.impl.evaluator.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.impl.strategy.sampling.SamplingEvictionStrategy;
import com.hazelcast.internal.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.NearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.SampleableNearCacheRecordMap;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetector;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.nearcache.NearCacheStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class AbstractNearCacheRecordStore<K, V, KS, R extends NearCacheRecord, NCRM extends SampleableNearCacheRecordMap<KS, R>>
implements NearCacheRecordStore<K, V>,
EvictionListener<KS, R> {
    private static final long MILLI_SECONDS_IN_A_SECOND = 1000L;
    private static final AtomicLongFieldUpdater<AbstractNearCacheRecordStore> RESERVATION_ID = AtomicLongFieldUpdater.newUpdater(AbstractNearCacheRecordStore.class, "reservationId");
    protected final long timeToLiveMillis;
    protected final long maxIdleMillis;
    protected final boolean evictionDisabled;
    protected final ClassLoader classLoader;
    protected final InMemoryFormat inMemoryFormat;
    protected final NearCacheConfig nearCacheConfig;
    protected final NearCacheStatsImpl nearCacheStats;
    protected final SerializationService serializationService;
    protected NCRM records;
    protected EvictionChecker evictionChecker;
    protected SamplingEvictionStrategy<KS, R, NCRM> evictionStrategy;
    protected EvictionPolicyEvaluator<KS, R> evictionPolicyEvaluator;
    protected volatile long reservationId;
    protected volatile StaleReadDetector staleReadDetector = StaleReadDetector.ALWAYS_FRESH;

    public AbstractNearCacheRecordStore(NearCacheConfig nearCacheConfig, SerializationService serializationService, ClassLoader classLoader) {
        this(nearCacheConfig, new NearCacheStatsImpl(), serializationService, classLoader);
    }

    protected AbstractNearCacheRecordStore(NearCacheConfig nearCacheConfig, NearCacheStatsImpl nearCacheStats, SerializationService serializationService, ClassLoader classLoader) {
        this.nearCacheConfig = nearCacheConfig;
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = (long)nearCacheConfig.getTimeToLiveSeconds() * 1000L;
        this.maxIdleMillis = (long)nearCacheConfig.getMaxIdleSeconds() * 1000L;
        this.serializationService = serializationService;
        this.classLoader = classLoader;
        this.nearCacheStats = nearCacheStats;
        this.evictionDisabled = nearCacheConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.NONE;
    }

    @Override
    public void initialize() {
        this.records = this.createNearCacheRecordMap(this.nearCacheConfig);
        EvictionConfig evictionConfig = this.nearCacheConfig.getEvictionConfig();
        this.evictionChecker = this.createNearCacheEvictionChecker(evictionConfig, this.nearCacheConfig);
        if (!this.evictionDisabled) {
            this.evictionStrategy = SamplingEvictionStrategy.INSTANCE;
            this.evictionPolicyEvaluator = EvictionPolicyEvaluatorProvider.getEvictionPolicyEvaluator(evictionConfig, this.classLoader);
        }
    }

    @Override
    public void setStaleReadDetector(StaleReadDetector staleReadDetector) {
        this.staleReadDetector = staleReadDetector;
    }

    public abstract R getRecord(K var1);

    protected abstract EvictionChecker createNearCacheEvictionChecker(EvictionConfig var1, NearCacheConfig var2);

    protected abstract NCRM createNearCacheRecordMap(NearCacheConfig var1);

    protected abstract long getKeyStorageMemoryCost(K var1);

    protected abstract long getRecordStorageMemoryCost(R var1);

    protected abstract R createRecord(V var1);

    protected abstract void updateRecordValue(R var1, V var2);

    protected abstract R reserveForReadUpdate(K var1, Data var2, long var3);

    protected abstract R reserveForWriteUpdate(K var1, Data var2, long var3);

    protected abstract R putRecord(K var1, R var2);

    protected abstract boolean containsRecordKey(K var1);

    protected void checkAvailable() {
        if (!this.isAvailable()) {
            throw new IllegalStateException(this.nearCacheConfig.getName() + " named Near Cache record store is not available");
        }
    }

    private boolean isAvailable() {
        return this.records != null;
    }

    protected Data toData(Object obj) {
        return this.serializationService.toData(obj);
    }

    protected V toValue(Object obj) {
        return (V)this.serializationService.toObject(obj);
    }

    protected long getTotalStorageMemoryCost(K key, R record) {
        return this.getKeyStorageMemoryCost(key) + this.getRecordStorageMemoryCost(record);
    }

    protected boolean isRecordExpired(R record) {
        if (!this.canUpdateStats(record)) {
            return false;
        }
        long now = Clock.currentTimeMillis();
        if (record.isExpiredAt(now)) {
            return true;
        }
        return record.isIdleAt(this.maxIdleMillis, now);
    }

    protected void onGet(K key, V value, R record) {
    }

    protected void onGetError(K key, V value, R record, Throwable error) {
    }

    protected void onPut(K key, V value, R record, R oldRecord) {
    }

    protected void onPutError(K key, V value, R record, R oldRecord, Throwable error) {
    }

    protected void onRemove(K key, R record, boolean removed) {
    }

    protected void onRemoveError(K key, R record, boolean removed, Throwable error) {
    }

    protected void onExpire(K key, R record) {
        this.nearCacheStats.incrementExpirations();
    }

    @Override
    public void onEvict(KS key, R record, boolean wasExpired) {
        if (wasExpired) {
            this.nearCacheStats.incrementExpirations();
        } else {
            this.nearCacheStats.incrementEvictions();
        }
        this.nearCacheStats.decrementOwnedEntryCount();
    }

    @Override
    public V get(K key) {
        this.checkAvailable();
        Evictable record = null;
        V value = null;
        try {
            record = (Evictable)this.getRecord(key);
            if (record == null) {
                this.nearCacheStats.incrementMisses();
                return null;
            }
            value = record.getValue();
            long recordState = record.getReservationId();
            if (recordState != -2L && !record.isCachedAsNull() && value == null) {
                this.nearCacheStats.incrementMisses();
                return null;
            }
            if (this.staleReadDetector.isStaleRead(key, (NearCacheRecord)record)) {
                this.invalidate(key);
                this.nearCacheStats.incrementMisses();
                return null;
            }
            if (this.isRecordExpired(record)) {
                this.invalidate(key);
                this.onExpire(key, record);
                return null;
            }
            this.onGet(key, value, record);
            this.onRecordAccess(record);
            this.nearCacheStats.incrementHits();
            return this.recordToValue(record);
        }
        catch (Throwable error) {
            this.onGetError(key, value, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected V recordToValue(R record) {
        return (V)(record.getValue() == null ? NearCache.CACHED_AS_NULL : this.toValue(record.getValue()));
    }

    @Override
    public void put(K key, Data keyData, V value, Data valueData) {
        long reservationId = this.tryReserveForUpdate(key, keyData, NearCache.UpdateSemantic.READ_UPDATE);
        if (reservationId != -1L) {
            this.tryPublishReserved(key, value, reservationId, false);
        }
    }

    public StaleReadDetector getStaleReadDetector() {
        return this.staleReadDetector;
    }

    protected boolean canUpdateStats(R record) {
        return record != null && record.getReservationId() == -2L;
    }

    @Override
    public void clear() {
        this.checkAvailable();
        int size = this.records.size();
        this.records.clear();
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
        this.nearCacheStats.incrementInvalidations(size);
        this.nearCacheStats.incrementInvalidationRequests();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        this.checkAvailable();
        return this.nearCacheStats;
    }

    @Override
    public int size() {
        this.checkAvailable();
        return this.records.size();
    }

    @Override
    public boolean doEviction(boolean withoutMaxSizeCheck) {
        this.checkAvailable();
        if (this.evictionDisabled) {
            return false;
        }
        EvictionChecker evictionChecker = withoutMaxSizeCheck ? null : this.evictionChecker;
        this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, evictionChecker, this);
        return true;
    }

    @Override
    public long tryReserveForUpdate(K key, Data keyData, NearCache.UpdateSemantic updateSemantic) {
        R reservedRecord;
        this.checkAvailable();
        if (this.evictionDisabled && this.evictionChecker.isEvictionRequired() && !this.containsRecordKey(key)) {
            return -1L;
        }
        long reservationId = this.nextReservationId();
        R r = reservedRecord = updateSemantic == NearCache.UpdateSemantic.WRITE_UPDATE ? this.reserveForWriteUpdate(key, keyData, reservationId) : this.reserveForReadUpdate(key, keyData, reservationId);
        if (reservedRecord == null || reservedRecord.getReservationId() != reservationId) {
            return -1L;
        }
        return reservationId;
    }

    protected R publishReservedRecord(K key, V value, R reservedRecord, long reservationId) {
        boolean update;
        if (reservedRecord.getReservationId() != reservationId) {
            return reservedRecord;
        }
        boolean bl = update = reservedRecord.getValue() != null || reservedRecord.isCachedAsNull();
        if (update) {
            this.nearCacheStats.incrementOwnedEntryMemoryCost(-this.getTotalStorageMemoryCost(key, reservedRecord));
        }
        this.updateRecordValue(reservedRecord, value);
        if (value == null) {
            reservedRecord.setCachedAsNull(true);
        }
        reservedRecord.setReservationId(-2L);
        this.nearCacheStats.incrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, reservedRecord));
        if (!update) {
            this.nearCacheStats.incrementOwnedEntryCount();
        }
        return reservedRecord;
    }

    private void onRecordAccess(R record) {
        record.setLastAccessTime(Clock.currentTimeMillis());
        record.incrementHits();
    }

    protected void initInvalidationMetaData(R record, K key, Data keyData) {
        if (this.staleReadDetector == StaleReadDetector.ALWAYS_FRESH) {
            return;
        }
        int partitionId = this.staleReadDetector.getPartitionId(keyData == null ? this.toData(key) : keyData);
        MetaDataContainer metaDataContainer = this.staleReadDetector.getMetaDataContainer(partitionId);
        record.setPartitionId(partitionId);
        record.setInvalidationSequence(metaDataContainer.getSequence());
        record.setUuid(metaDataContainer.getUuid());
    }

    private long nextReservationId() {
        return RESERVATION_ID.incrementAndGet(this);
    }

    protected R newReservationRecord(K key, Data keyData, long reservationId) {
        NearCacheRecord record = null;
        try {
            record = (NearCacheRecord)this.createRecord(null);
            record.setReservationId(reservationId);
            this.initInvalidationMetaData(record, key, keyData);
        }
        catch (Throwable throwable) {
            this.onPutError(key, null, record, null, throwable);
            throw ExceptionUtil.rethrow(throwable);
        }
        return (R)record;
    }

    protected R reserveForWriteUpdate(K key, Data keyData, R existingRecord, long reservationId) {
        if (existingRecord == null) {
            return this.newReservationRecord(key, keyData, reservationId);
        }
        if (existingRecord.getReservationId() == -2L) {
            existingRecord.setReservationId(reservationId);
            return existingRecord;
        }
        return null;
    }
}

